/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.sentencetype;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceTypeFeatureExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(SentenceTypeFeatureExtractor.class);
    private static final Set<String> IMPERATIVE_KEYWORDS = ImmutableSet.of((Object)"verify", (Object)"ask", (Object)"say", (Object)"solve", (Object)"run", (Object)"execute", (Object[])new String[0]);
    private static final Set<String> QUESTION_PREFIX = ImmutableSet.of((Object)"let me know", (Object)"clarify for me", (Object)"name");

    public List<String> generateFeats(String[] tokens) {
        long whetherKeyWord;
        if ((tokens = (String[])Arrays.stream(tokens).filter(Objects::nonNull).filter(x -> !x.trim().isEmpty()).map(String::toLowerCase).toArray(String[]::new)).length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> feats = new ArrayList<String>();
        feats.add("word_count_" + String.valueOf(tokens.length));
        if (tokens[0].toLowerCase().startsWith("wh")) {
            feats.add("wh_start");
        }
        boolean isImperativeStart = IMPERATIVE_KEYWORDS.contains(tokens[0]);
        String lastToken = tokens[tokens.length - 1];
        if (isImperativeStart) {
            feats.add("imperative_start");
            if (!Pattern.matches("\\p{Punct}+", lastToken)) {
                String[] newTokens = new String[tokens.length + 1];
                System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
                tokens = newTokens;
            }
            tokens[tokens.length - 1] = "!";
        }
        String sentence = Arrays.stream(tokens).collect(Collectors.joining(" "));
        long questionPrefixCount = QUESTION_PREFIX.stream().filter(sentence::startsWith).count();
        if (questionPrefixCount > 0L) {
            feats.add("question_prefix");
            if (!Pattern.matches("\\p{Punct}+", lastToken)) {
                String[] newTokens = new String[tokens.length + 1];
                System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
                tokens = newTokens;
            }
            tokens[tokens.length - 1] = "?";
        }
        feats.add("first_word_" + tokens[0]);
        if (tokens.length > 1) {
            feats.add("sec_word_" + tokens[1]);
        }
        if (Pattern.matches("\\p{Punct}+", lastToken = tokens[tokens.length - 1])) {
            feats.add("punct_" + lastToken);
        }
        if ((whetherKeyWord = Arrays.stream(tokens).filter("whether"::equals).count()) > 0L) {
            feats.add("has_whether");
        }
        ArrayList<String> biWord = new ArrayList<String>();
        ArrayList<String> triWord = new ArrayList<String>();
        for (int i = 0; i < tokens.length && i < 6; ++i) {
            if (i + 1 < tokens.length) {
                biWord.add(tokens[i] + "_" + tokens[i + 1]);
            }
            if (i + 2 >= tokens.length) continue;
            triWord.add(tokens[i] + "_" + tokens[i + 1] + "_" + tokens[i + 2]);
        }
        feats.addAll(biWord);
        feats.addAll(triWord);
        return feats;
    }
}

