/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.sampling;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Random;

public class ReservoirSampling {
    public static <T> T[] sample(int k, Iterator<T> sequenceIter) {
        int i;
        T firstElement = sequenceIter.next();
        Object[] samples = (Object[])Array.newInstance(firstElement.getClass(), k);
        for (i = 0; i < k; ++i) {
            if (i == 0) {
                samples[i] = firstElement;
                continue;
            }
            if (!sequenceIter.hasNext()) {
                throw new RuntimeException("Sequence has less elements than " + k);
            }
            samples[i] = sequenceIter.next();
        }
        i = k + 1;
        while (sequenceIter.hasNext()) {
            int j = new Random().nextInt(i);
            T Si = sequenceIter.next();
            if (j < k) {
                samples[j] = Si;
            }
            ++i;
        }
        return samples;
    }
}

