/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.chunker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.maochen.nlp.app.featextractor.BrownFeatExtractor;
import org.maochen.nlp.app.featextractor.IFeatureExtractor;
import org.maochen.nlp.ml.SequenceTuple;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.vector.IVector;
import org.maochen.nlp.ml.vector.LabeledVector;

public class ChunkerFeatureExtractor
implements IFeatureExtractor {
    public static final int WORD_INDEX = 0;
    public static final int POS_INDEX = 1;

    public List<String> extractFeatSingle(int i, String[] tokens, String[] pos) {
        int index;
        ArrayList<String> currentFeats = new ArrayList<String>();
        for (index = Math.max(0, i - 2); index < Math.min(i + 3, tokens.length); ++index) {
            this.addFeat(currentFeats, "w" + (index - i), tokens[index]);
            this.addFeat(currentFeats, "pos" + (index - i), pos[index]);
            if (index == i - 1) {
                this.addFeat(currentFeats, "w-10", tokens[i - 1], tokens[i]);
                this.addFeat(currentFeats, "pos-10", pos[i - 1], pos[i]);
            } else if (index == i + 1) {
                this.addFeat(currentFeats, "w0+1", tokens[i], tokens[i + 1]);
                this.addFeat(currentFeats, "pos0+1", pos[i], pos[i + 1]);
            } else if (index == i - 2) {
                this.addFeat(currentFeats, "pos-2-1", pos[i - 2], pos[i - 1]);
                this.addFeat(currentFeats, "pos-2-10", pos[i - 2], pos[i - 1], pos[i]);
            } else if (index == i + 2) {
                this.addFeat(currentFeats, "pos+1+2", pos[i + 1], pos[i + 2]);
            }
            if (index == i - 1 && i < tokens.length - 1) {
                this.addFeat(currentFeats, "pos-10+1", pos[i - 1], pos[i], pos[i + 1]);
            }
            if (index != i + 2) continue;
            this.addFeat(currentFeats, "pos0+1+2", pos[i], pos[i + 1], pos[i + 2]);
        }
        index = Math.max(0, i - 2);
        while (index < Math.min(i + 3, tokens.length)) {
            Map<String, String> feats = BrownFeatExtractor.extractBrownFeat(tokens[index]);
            int finalIndex = index++;
            feats.entrySet().stream().forEach(entry -> this.addFeat(currentFeats, (String)entry.getKey() + "_" + (finalIndex - i), (String)entry.getValue()));
        }
        return currentFeats;
    }

    @Override
    public List<Tuple> extractFeat(SequenceTuple entry) {
        String[] tokens = (String[])entry.entries.stream().map(tuple -> ((LabeledVector)tuple.vector).featsName[0]).toArray(String[]::new);
        String[] pos = (String[])entry.entries.stream().map(tuple -> ((LabeledVector)tuple.vector).featsName[1]).toArray(String[]::new);
        List feats = IntStream.range(0, tokens.length).mapToObj(i -> this.extractFeatSingle(i, tokens, pos)).collect(Collectors.toList());
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i2 = 0; i2 < feats.size(); ++i2) {
            List singleTokenFeat = (List)feats.get(i2);
            LabeledVector v = new LabeledVector((String[])singleTokenFeat.stream().toArray(String[]::new));
            Tuple t = new Tuple((IVector)v);
            t.label = ((Tuple)entry.entries.get((int)i2)).label;
            tuples.add(t);
        }
        return tuples;
    }
}

