/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.ner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.maochen.nlp.app.featextractor.BrownFeatExtractor;
import org.maochen.nlp.app.featextractor.IFeatureExtractor;
import org.maochen.nlp.ml.SequenceTuple;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.vector.IVector;
import org.maochen.nlp.ml.vector.LabeledVector;

public class NERFeatureExtractor
implements IFeatureExtractor {
    private static String getWordShape(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isUpperCase(str.charAt(i))) {
                stringBuilder.append("X");
                continue;
            }
            stringBuilder.append("x");
        }
        return stringBuilder.toString().trim();
    }

    public List<String> extractFeatSingle(int i, String[] tokens) {
        int index;
        ArrayList<String> currentFeats = new ArrayList<String>();
        for (index = Math.max(0, i - 2); index < Math.min(i + 3, tokens.length); ++index) {
            boolean containsDigitCharacter;
            this.addFeat(currentFeats, "w" + (index - i), tokens[index]);
            this.addFeat(currentFeats, "word_length", String.valueOf(tokens[index].length()));
            this.addFeat(currentFeats, "word_shape", NERFeatureExtractor.getWordShape(tokens[index]));
            boolean containsDigit = Pattern.compile("\\d+").matcher(tokens[index]).find();
            boolean containsTwoDigit = Pattern.compile("\\d{2}").matcher(tokens[index]).find();
            boolean containsFourDigit = Pattern.compile("\\d{4}").matcher(tokens[index]).find();
            boolean containsChar = Pattern.compile("[%|,|.|/|-]").matcher(tokens[index]).find();
            boolean bl = containsDigitCharacter = containsChar && containsDigit;
            if (containsChar) {
                this.addFeat(currentFeats, "contains_char", new String[0]);
            }
            if (containsDigit) {
                this.addFeat(currentFeats, "contains_digit", new String[0]);
            }
            if (containsTwoDigit) {
                this.addFeat(currentFeats, "contains_two_digit", new String[0]);
            }
            if (containsFourDigit) {
                this.addFeat(currentFeats, "contains_four_digit", new String[0]);
            }
            if (containsDigitCharacter) {
                this.addFeat(currentFeats, "contains_digit_char", new String[0]);
            }
            if (index == i - 1) {
                this.addFeat(currentFeats, "w-10", tokens[i - 1], tokens[i]);
                continue;
            }
            if (index != i + 1) continue;
            this.addFeat(currentFeats, "w0+1", tokens[i], tokens[i + 1]);
        }
        index = Math.max(0, i - 2);
        while (index < Math.min(i + 3, tokens.length)) {
            Map<String, String> feats = BrownFeatExtractor.extractBrownFeat(tokens[index]);
            int finalIndex = index++;
            feats.entrySet().stream().forEach(entry -> this.addFeat(currentFeats, (String)entry.getKey() + "_" + (finalIndex - i), (String)entry.getValue()));
        }
        return currentFeats;
    }

    @Override
    public List<Tuple> extractFeat(SequenceTuple entry) {
        String[] tokens = (String[])entry.entries.stream().map(tuple -> ((LabeledVector)tuple.vector).featsName[0]).toArray(String[]::new);
        List feats = IntStream.range(0, tokens.length).mapToObj(i -> this.extractFeatSingle(i, tokens)).collect(Collectors.toList());
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i2 = 0; i2 < feats.size(); ++i2) {
            List singleTokenFeat = (List)feats.get(i2);
            LabeledVector v = new LabeledVector((String[])singleTokenFeat.stream().toArray(String[]::new));
            Tuple t = new Tuple((IVector)v);
            t.label = ((Tuple)entry.entries.get((int)i2)).label;
            tuples.add(t);
        }
        return tuples;
    }
}

