/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.classifier;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.maochen.nlp.ml.Tuple;

public class LabelIndexer {
    public BiMap<String, Integer> labelIndexer = HashBiMap.create();

    public int getIndex(String label) {
        return (Integer)this.labelIndexer.get((Object)label);
    }

    public String getLabel(int index) {
        return (String)this.labelIndexer.inverse().get((Object)index);
    }

    public void putByLabels(List<String> labels) {
        Collections.sort(labels);
        int maxIndex = this.labelIndexer.values().stream().max(Integer::compareTo).orElse(-1);
        IntStream.range(0, labels.size()).forEachOrdered(i -> {
            Integer cfr_ignored_0 = (Integer)this.labelIndexer.put(labels.get(i), (Object)(maxIndex + 1 + i));
        });
    }

    public boolean hasLabel(String label) {
        return this.labelIndexer.containsKey((Object)label);
    }

    public Set<Integer> getIndexSet() {
        return this.labelIndexer.inverse().keySet();
    }

    public int getLabelSize() {
        return this.labelIndexer.size();
    }

    public Map<String, Double> convertMapKey(Map<Integer, Double> probs) {
        HashMap<String, Double> stringKeyProb = new HashMap<String, Double>();
        probs.entrySet().stream().forEach(e -> {
            Double cfr_ignored_0 = (Double)stringKeyProb.put(this.getLabel((Integer)e.getKey()), (Double)e.getValue());
        });
        return stringKeyProb;
    }

    public LabelIndexer(List<Tuple> trainingData) {
        List<String> labels = trainingData.parallelStream().map(tuple -> tuple.label).distinct().collect(Collectors.toList());
        this.putByLabels(labels);
    }
}

