/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.classifier.hmm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.maochen.nlp.ml.classifier.hmm.HMMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Viterbi {
    private static final Logger LOG = LoggerFactory.getLogger(Viterbi.class);

    public static List<String> resolve(HMMModel model, String[] words) {
        HashSet tagSet = new HashSet();
        for (String word : words) {
            tagSet.addAll(model.emission.row((Object)word).keySet());
        }
        ArrayList<String> tags = new ArrayList<String>(tagSet);
        tags.add(0, "<START>");
        tags.add("<END>");
        ArrayList<String> rowString = tags;
        List colString = Arrays.stream(words).collect(Collectors.toList());
        colString.add(0, "<START>");
        colString.add("<END>");
        double[][] matrix = new double[rowString.size()][colString.size()];
        int[] path = new int[colString.size()];
        matrix[0][0] = 1.0;
        for (int col = 1; col < matrix[0].length; ++col) {
            String word = (String)colString.get(col);
            for (int row = 1; row < matrix.length; ++row) {
                String currentTag = (String)rowString.get(row);
                for (int prevRow = 0; prevRow < matrix.length; ++prevRow) {
                    double prevViterbi;
                    double newViterbi;
                    if (matrix[prevRow][col - 1] == 0.0) continue;
                    String prevTag = (String)rowString.get(prevRow);
                    Double trans = (Double)model.transition.get((Object)prevTag, (Object)currentTag);
                    trans = trans == null ? 0.0 : trans;
                    Double emission = (Double)model.emission.get((Object)word, (Object)currentTag);
                    if (emission == null) {
                        if (!model.emission.rowKeySet().contains(word)) {
                            LOG.debug("Missing word: " + word);
                            emission = model.emissionMin.get(currentTag);
                        }
                        if (emission == null) {
                            emission = 0.0;
                        }
                    }
                    if (!((newViterbi = (prevViterbi = matrix[prevRow][col - 1]) * trans * emission) > matrix[row][col])) continue;
                    matrix[row][col] = newViterbi;
                    path[col - 1] = prevRow;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path: " + (String)Arrays.stream(path).filter(Objects::nonNull).mapToObj(String::valueOf).reduce((x1, x2) -> x1 + " " + x2).orElse(null));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\t\t").append((String)colString.stream().reduce((x1, x2) -> x1 + "\t" + x2).orElse(null)).append(System.lineSeparator());
            for (int i = 0; i < matrix.length; ++i) {
                for (int j = 0; j < matrix[i].length; ++j) {
                    if (j == 0) {
                        stringBuilder.append((String)rowString.get(i)).append("\t");
                    }
                    stringBuilder.append(String.format("%.4f", matrix[i][j])).append("\t");
                }
                stringBuilder.append(System.lineSeparator());
            }
            Arrays.stream(stringBuilder.toString().split(System.lineSeparator())).forEach(arg_0 -> ((Logger)LOG).debug(arg_0));
        }
        List<String> result = Arrays.stream(path).filter(Objects::nonNull).filter(rowIndex -> rowIndex != 0).mapToObj(rowString::get).collect(Collectors.toList());
        LOG.debug(result.toString());
        return result;
    }
}

