/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.maochen.nlp.util.BiFunctionDoublePrimitive;

public class VectorUtils {
    public static Function<Double, Double> sigmoid = z -> 1.0 / (1.0 + Math.exp(-z.doubleValue()));
    public static Function<Double, Double> tanh = z -> {
        double e2z = Math.exp(2.0 * z);
        return (e2z - 1.0) / (e2z + 1.0);
    };
    public static final BiFunction<double[], double[], Double> euclideanDistance = (v1, v2) -> {
        double result = 0.0;
        for (int i = 0; i < ((double[])v1).length; ++i) {
            double diff = v1[i] - v2[i];
            diff *= diff;
            result += diff;
        }
        result = Math.sqrt(result);
        return result;
    };

    public static double[] zip(double[] vec1, double[] vec2, BiFunctionDoublePrimitive op) {
        if (vec1 == null || vec2 == null) {
            return new double[0];
        }
        if (vec1.length != vec2.length) {
            throw new IllegalArgumentException("Two Vectors must has equal length.");
        }
        double[] result = new double[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            result[i] = op.apply(vec1[i], vec2[i]);
        }
        return result;
    }

    public static double[] addition(double[] ... vectors) {
        int dim = 0;
        for (double[] vector : vectors) {
            if (vector == null || vector.length == 0) continue;
            dim = vector.length;
            break;
        }
        double[] result = new double[dim];
        for (int i = 0; i < vectors.length; ++i) {
            if (vectors[i] == null || vectors[i].length == 0) continue;
            for (int dimension = 0; dimension < vectors[i].length; ++dimension) {
                int n = dimension;
                result[n] = result[n] + vectors[i][dimension];
            }
        }
        return result;
    }

    public static double dotProduct(double[] vec1, double[] vec2) {
        double sum = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            sum += vec1[i] * vec2[i];
        }
        return sum;
    }

    public static double vectorLen(double[] vector) {
        double sum = 0.0;
        for (double d : vector) {
            sum += d * d;
        }
        return Math.sqrt(sum);
    }

    public static double getCosinValue(double[] vector1, double[] vector2) {
        double euclideanDistance;
        if (vector1 == null || vector2 == null) {
            return 0.0;
        }
        double dotProduct = VectorUtils.dotProduct(vector1, vector2);
        double cosineValue = Math.abs(dotProduct / (euclideanDistance = VectorUtils.vectorLen(vector1) * VectorUtils.vectorLen(vector2)));
        return cosineValue > 1.0 ? 1.0 : cosineValue;
    }

    public static void scale(double[] a, double scale) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * scale;
        }
    }

    public static double gaussianPDF(double mean, double variance, double x) {
        double twoVariance = 2.0 * variance;
        double probability = 1.0 / Math.sqrt(Math.PI * twoVariance);
        return probability *= Math.exp(-Math.pow(x - mean, 2.0) / twoVariance);
    }

    public static float[] doubleToFloat(double[] vector) {
        float[] result = new float[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            result[i] = (float)vector[i];
        }
        return result;
    }

    public static double[] floatToDouble(float[] vector) {
        double[] result = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            result[i] = vector[i];
        }
        return result;
    }

    public static String[] intToString(int[] vectorIndex) {
        String[] result = new String[vectorIndex.length];
        for (int i = 0; i < vectorIndex.length; ++i) {
            result[i] = String.valueOf(vectorIndex[i]);
        }
        return result;
    }
}

