/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.classifier.maxent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.model.ComparableEvent;
import opennlp.model.DataIndexer;
import opennlp.model.Event;
import org.maochen.nlp.ml.classifier.maxent.eventstream.EventStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnePassRealValueDataIndexer
implements DataIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(OnePassRealValueDataIndexer.class);
    private float[][] values;
    private int numEvents;
    protected int[][] contexts;
    protected int[] outcomeList;
    protected String[] outcomeLabels;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected int[] predCounts;

    public OnePassRealValueDataIndexer(EventStream eventStream, int cutoff, boolean sort) {
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        LOG.debug("Indexing events using cutoff of " + cutoff);
        LinkedList<Event> events = this.computeEventCounts(eventStream, predicateIndex, cutoff);
        LOG.debug("Computed event counts... " + events.size());
        List<ComparableEvent> eventsToCompare = this.index(events, predicateIndex);
        LOG.debug("Indexing... done.");
        LOG.debug("Sorting and merging events... ");
        this.sortAndMerge(eventsToCompare, sort);
        LOG.debug("Done indexing.");
    }

    private LinkedList<Event> computeEventCounts(EventStream eventStream, Map<String, Integer> predicatesInOut, int cutoff) {
        HashSet<String> predicateSet = new HashSet<String>();
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        LinkedList<Event> events = new LinkedList<Event>();
        while (eventStream.hasNext()) {
            Event ev = eventStream.next();
            events.addLast(ev);
            OnePassRealValueDataIndexer.update(ev.getContext(), predicateSet, counter, cutoff);
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            this.predCounts[index] = (Integer)counter.get(predicate);
            predicatesInOut.put(predicate, index);
            ++index;
        }
        return events;
    }

    protected static void update(String[] ec, Set<String> predicateSet, Map<String, Integer> counter, int cutoff) {
        for (String s : ec) {
            Integer val = counter.get(s);
            val = val == null ? 1 : val + 1;
            counter.put(s, val);
            if (predicateSet.contains(s) || counter.get(s) < cutoff) continue;
            predicateSet.add(s);
        }
    }

    protected int sortAndMerge(List<ComparableEvent> eventsToCompare, boolean sort) {
        ComparableEvent evt;
        int i;
        int numUniqueEvents = 1;
        this.numEvents = eventsToCompare.size();
        if (this.numEvents <= 1) {
            return numUniqueEvents;
        }
        if (sort) {
            eventsToCompare.sort(ComparableEvent::compareTo);
            ComparableEvent ce = eventsToCompare.get(0);
            for (int i2 = 1; i2 < this.numEvents; ++i2) {
                ComparableEvent ce2 = eventsToCompare.get(i2);
                if (ce.compareTo(ce2) == 0) {
                    ++ce.seen;
                    eventsToCompare.set(i2, null);
                    continue;
                }
                ce = ce2;
                ++numUniqueEvents;
            }
            LOG.debug("done. Reduced " + this.numEvents + " events to " + numUniqueEvents + ".");
        } else {
            numUniqueEvents = eventsToCompare.size();
        }
        this.contexts = new int[numUniqueEvents][];
        this.outcomeList = new int[numUniqueEvents];
        this.numTimesEventsSeen = new int[numUniqueEvents];
        int j = 0;
        for (i = 0; i < this.numEvents; ++i) {
            evt = eventsToCompare.get(i);
            if (null == evt) continue;
            this.numTimesEventsSeen[j] = evt.seen;
            this.outcomeList[j] = evt.outcome;
            this.contexts[j] = evt.predIndexes;
            ++j;
        }
        this.values = new float[numUniqueEvents][];
        j = 0;
        for (i = 0; i < this.numEvents; ++i) {
            evt = eventsToCompare.get(i);
            if (null == evt) continue;
            this.values[j++] = evt.values;
        }
        return numUniqueEvents;
    }

    protected static String[] toIndexedStringArray(Map<String, Integer> labelToIndexMap) {
        String[] array = new String[labelToIndexMap.size()];
        Iterator<String> iterator = labelToIndexMap.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            array[labelToIndexMap.get((Object)label).intValue()] = label = iterator.next();
        }
        return array;
    }

    protected List<ComparableEvent> index(LinkedList<Event> events, Map<String, Integer> predicateIndex) {
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int numEvents = events.size();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        for (int eventIndex = 0; eventIndex < numEvents; ++eventIndex) {
            int ocID;
            Event ev = events.removeFirst();
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (String pred : econtext) {
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons, ev.getValues());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.clear();
        }
        this.outcomeLabels = OnePassRealValueDataIndexer.toIndexedStringArray(omap);
        this.predLabels = OnePassRealValueDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public int[][] getContexts() {
        return this.contexts;
    }

    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    public String[] getPredLabels() {
        return this.predLabels;
    }

    public int[] getPredCounts() {
        return this.predCounts;
    }

    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    public float[][] getValues() {
        return this.values;
    }
}

