/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford;

import com.google.common.collect.ImmutableSet;
import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.maochen.nlp.parser.DTree;
import org.maochen.nlp.parser.IParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StanfordParser
implements IParser {
    private static final Logger LOG = LoggerFactory.getLogger(StanfordParser.class);
    private static MaxentTagger posTagger = null;
    private static String POS_TAGGER_MODEL_PATH = null;
    private List<NERClassifierCombiner> ners;
    private static final Set<String> particles = ImmutableSet.of((Object)"abroad", (Object)"across", (Object)"after", (Object)"ahead", (Object)"along", (Object)"aside", (Object[])new String[]{"away", "around", "back", "down", "forward", "in", "off", "on", "over", "out", "round", "together", "through", "up"});

    public static List<CoreLabel> stanfordTokenize(String str) {
        TokenizerFactory tf = PTBTokenizer.coreLabelFactory();
        Tokenizer originalWordTokenizer = tf.getTokenizer((Reader)new StringReader(str), "ptb3Escaping=false");
        Tokenizer tokenizer = tf.getTokenizer((Reader)new StringReader(str));
        List originalTokens = originalWordTokenizer.tokenize();
        List tokens = tokenizer.tokenize();
        ArrayList<CoreLabel> coreLabels = new ArrayList<CoreLabel>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            CoreLabel coreLabel = new CoreLabel();
            coreLabel.setWord(((HasWord)tokens.get(i)).word());
            coreLabel.setOriginalText(((HasWord)originalTokens.get(i)).word());
            coreLabel.setValue(((HasWord)tokens.get(i)).word());
            coreLabel.setBeginPosition(((CoreLabel)tokens.get(i)).beginPosition());
            coreLabel.setEndPosition(((CoreLabel)tokens.get(i)).endPosition());
            coreLabels.add(coreLabel);
        }
        return coreLabels;
    }

    public void tagPOS(List<CoreLabel> tokens) {
        if (posTagger == null) {
            if (POS_TAGGER_MODEL_PATH == null) {
                LOG.warn("Default POS Tagger model");
                POS_TAGGER_MODEL_PATH = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";
            }
            posTagger = new MaxentTagger(POS_TAGGER_MODEL_PATH);
        }
        List posList = posTagger.tagSentence(tokens);
        for (int i = 0; i < tokens.size(); ++i) {
            String pos = ((TaggedWord)posList.get(i)).tag();
            tokens.get(i).setTag(pos);
        }
    }

    private static String phrasalVerb(Morphology morpha, String word, String tag) {
        assert (word != null);
        assert (tag != null);
        if (!tag.startsWith("VB") || !word.contains("_")) {
            return null;
        }
        String[] verb = word.split("_");
        if (verb.length != 2) {
            return null;
        }
        String particle = verb[1];
        if (particles.contains(particle)) {
            String base = verb[0];
            String lemma = morpha.lemma(base, tag);
            return lemma + '_' + particle;
        }
        return null;
    }

    public static void tagLemma(List<CoreLabel> tokens) {
        Morphology morpha = new Morphology();
        for (CoreLabel token : tokens) {
            String phrasalVerb;
            String pos = token.tag();
            if (pos.equals("NNPS")) {
                pos = "NNS";
            }
            String lemma = pos.length() > 0 ? ((phrasalVerb = StanfordParser.phrasalVerb(morpha, token.word(), pos)) == null ? morpha.lemma(token.word(), pos) : phrasalVerb) : morpha.stem(token.word());
            if (lemma.equals("i")) {
                lemma = "I";
            }
            token.setLemma(lemma);
        }
    }

    public synchronized void tagNamedEntity(List<CoreLabel> tokens) {
        boolean isPOSTagged;
        boolean bl = isPOSTagged = tokens.parallelStream().filter(x -> x.tag() == null).count() == 0L;
        if (!isPOSTagged) {
            throw new RuntimeException("Please Run POS Tagger before Named Entity tagger.");
        }
        if (this.ners != null) {
            try {
                this.ners.stream().forEach(ner -> ner.classify(tokens));
            }
            catch (Exception e) {
                LOG.warn("NER Classifier err for: " + tokens.stream().map(CoreLabel::word).collect(Collectors.joining(" ")));
            }
        }
    }

    @Override
    public abstract DTree parse(String var1);

    protected void load(String posTaggerModel, List<String> nerModels) {
        POS_TAGGER_MODEL_PATH = posTaggerModel;
        if (nerModels != null) {
            if (nerModels.isEmpty()) {
                nerModels.add("edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz");
                nerModels.add("edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz");
            }
            this.ners = nerModels.stream().map(path -> {
                NERClassifierCombiner nerClassifierCombiner = null;
                try {
                    nerClassifierCombiner = new NERClassifierCombiner(new String[]{path});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return nerClassifierCombiner;
            }).collect(Collectors.toList());
        }
    }
}

