/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.featextractor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.maochen.nlp.app.featextractor.IFeatureExtractor;

public class BrownFeatExtractor {
    private static Map<String, String> BROWN_CLUSTER = new HashMap<String, String>();
    private static int[] BROWN_PREFIX;

    public static Map<String, String> extractBrownFeat(String word) {
        if (!BROWN_CLUSTER.containsKey(word)) {
            return new HashMap<String, String>();
        }
        String clusterId = BROWN_CLUSTER.get(word);
        return Arrays.stream(BROWN_PREFIX).mapToObj(p -> {
            int end = Math.min(p, clusterId.length());
            return new AbstractMap.SimpleEntry<String, String>("brown_" + p, clusterId.substring(0, end));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<String> extractBrownFeat(int currentIndex, int negOffset, int posOffset, String[] tokens) {
        ArrayList<String> currentFeats = new ArrayList<String>();
        int index = Math.max(0, currentIndex + negOffset);
        while (index < Math.min(currentIndex + posOffset + 1, tokens.length)) {
            Map<String, String> feats = BrownFeatExtractor.extractBrownFeat(tokens[index]);
            int finalIndex = index++;
            feats.entrySet().stream().forEach(entry -> IFeatureExtractor.addFeat(currentFeats, (String)entry.getKey() + "_" + (finalIndex - currentIndex), (String)entry.getValue()));
        }
        return currentFeats;
    }

    static {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(BrownFeatExtractor.class.getResourceAsStream("/brown.rcv1.3200.txt")));){
            String line = br.readLine();
            while (line != null) {
                String[] fields = line.split("\\s");
                BROWN_CLUSTER.put(fields[1], fields[0]);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BROWN_PREFIX = new int[]{4, 6, 10, 20};
    }
}

