/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.classifier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.maochen.nlp.ml.vector.FeatNamedVector;

public class FeatureIndexer {
    private Map<String, Integer> nameIndexMap = new HashMap<String, Integer>();

    private String[] getNames(List<FeatNamedVector> trainingSamples) {
        HashSet nameSet = new HashSet();
        trainingSamples.forEach(t -> {
            for (String s : t.featsName) {
                String featName = s.split("=")[0];
                nameSet.add(featName);
            }
        });
        return (String[])nameSet.stream().toArray(String[]::new);
    }

    public double[][] process(List<FeatNamedVector> trainingSamples) {
        if (trainingSamples == null) {
            throw new RuntimeException("Training samples is null.");
        }
        String[] namesArray = this.getNames(trainingSamples);
        for (int i = 0; i < namesArray.length; ++i) {
            this.nameIndexMap.put(namesArray[i], i);
        }
        double[][] vectors = new double[trainingSamples.size()][];
        for (int i = 0; i < trainingSamples.size(); ++i) {
            FeatNamedVector featureVector = trainingSamples.get(i);
            double[] vector = new double[this.nameIndexMap.size()];
            for (int j = 0; j < featureVector.featsName.length; ++j) {
                String[] featNameFields = featureVector.featsName[j].split("=");
                String featName = featNameFields[0];
                try {
                    double featVal = featNameFields.length < 2 ? featureVector.getVector()[j] : Double.parseDouble(featNameFields[1]);
                    int featIndex = this.nameIndexMap.get(featName);
                    vector[featIndex] = featVal;
                    continue;
                }
                catch (Exception e) {
                    System.out.println(featName);
                    throw e;
                }
            }
            vectors[i] = vector;
        }
        return vectors;
    }

    public String[] getFeatNames() {
        String[] namesArray = new String[this.nameIndexMap.size()];
        for (Map.Entry<String, Integer> entry : this.nameIndexMap.entrySet()) {
            namesArray[entry.getValue().intValue()] = entry.getKey();
        }
        return namesArray;
    }
}

