/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.pcfg;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ScoredObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.maochen.nlp.parser.DTree;
import org.maochen.nlp.parser.stanford.StanfordParser;
import org.maochen.nlp.parser.stanford.pcfg.StanfordTreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StanfordPCFGParser
extends StanfordParser {
    private static final Logger LOG = LoggerFactory.getLogger(StanfordPCFGParser.class);
    private LexicalizedParser parser = null;

    public void tagPOS(List<CoreLabel> tokens, Tree tree) {
        try {
            ArrayList posList = tree.getChild(0).taggedYield();
            for (int i = 0; i < tokens.size(); ++i) {
                String pos = ((TaggedWord)posList.get(i)).tag();
                tokens.get(i).setTag(pos);
            }
        }
        catch (Exception e) {
            this.tagPOS(tokens);
            LOG.warn("POS Failed:\n" + tree.pennString());
        }
    }

    public Pair<CoreMap, GrammaticalStructure> parseForCoref(String sentence) {
        List<CoreLabel> tokens = StanfordPCFGParser.stanfordTokenize(sentence);
        Tree tree = this.parser.parse(tokens);
        GrammaticalStructure gs = this.tagDependencies(tree, true);
        this.tagPOS(tokens);
        StanfordPCFGParser.tagLemma(tokens);
        this.tagNamedEntity(tokens);
        ArrayCoreMap result = new ArrayCoreMap();
        result.set(CoreAnnotations.TokensAnnotation.class, tokens);
        result.set(TreeCoreAnnotations.TreeAnnotation.class, (Object)tree);
        GrammaticalStructure.Extras extras = GrammaticalStructure.Extras.NONE;
        SemanticGraph deps = SemanticGraphFactory.generateCollapsedDependencies((GrammaticalStructure)gs, (GrammaticalStructure.Extras)extras);
        SemanticGraph uncollapsedDeps = SemanticGraphFactory.generateUncollapsedDependencies((GrammaticalStructure)gs, (GrammaticalStructure.Extras)extras);
        SemanticGraph ccDeps = SemanticGraphFactory.generateCCProcessedDependencies((GrammaticalStructure)gs, (GrammaticalStructure.Extras)extras);
        result.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, (Object)deps);
        result.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, (Object)uncollapsedDeps);
        result.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, (Object)ccDeps);
        return new ImmutablePair((Object)result, (Object)gs);
    }

    private GrammaticalStructure tagDependencies(Tree tree, boolean makeCopulaVerbHead) {
        SemanticHeadFinder headFinder = new SemanticHeadFinder(!makeCopulaVerbHead);
        EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree, string -> true, (HeadFinder)headFinder);
        return gs;
    }

    @Override
    public DTree parse(String sentence) {
        if (sentence == null || sentence.trim().isEmpty()) {
            return null;
        }
        List<CoreLabel> tokens = StanfordPCFGParser.stanfordTokenize(sentence);
        Tree tree = this.parser.parse(tokens);
        GrammaticalStructure gs = this.tagDependencies(tree, true);
        this.tagPOS(tokens, tree);
        StanfordPCFGParser.tagLemma(tokens);
        this.tagNamedEntity(tokens);
        DTree dTree = StanfordTreeBuilder.generate(tokens, gs.typedDependencies(), null);
        dTree.setOriginalSentence(sentence);
        return dTree;
    }

    public Table<DTree, Tree, Double> getKBestParse(String sentence, int k) {
        if (this.parser == null) {
            LOG.info("Use default PCFG model.");
            this.parser = LexicalizedParser.loadModel();
        }
        List<CoreLabel> tokens = StanfordPCFGParser.stanfordTokenize(sentence);
        ParserQuery pq = this.parser.parserQuery();
        pq.parse(tokens);
        List scoredTrees = pq.getKBestPCFGParses(k);
        HashBasedTable result = HashBasedTable.create();
        for (ScoredObject scoredTuple : scoredTrees) {
            Tree tree = (Tree)scoredTuple.object();
            this.tagPOS(tokens, tree);
            StanfordPCFGParser.tagLemma(tokens);
            this.tagNamedEntity(tokens);
            GrammaticalStructure gs = this.tagDependencies(tree, true);
            DTree depTree = StanfordTreeBuilder.generate(tokens, gs.typedDependencies(), null);
            result.put((Object)depTree, (Object)tree, (Object)scoredTuple.score());
        }
        return result;
    }

    public StanfordPCFGParser() {
        this(null, null, null);
    }

    public StanfordPCFGParser(String modelPath, String posTaggerModel, List<String> ners) {
        if (modelPath == null || modelPath.trim().isEmpty()) {
            modelPath = "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz";
        }
        this.parser = LexicalizedParser.loadModel((String)modelPath, new ArrayList());
        super.load(posTaggerModel, ners);
    }
}

