/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.nn;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.trees.GrammaticalStructure;
import java.util.List;
import org.maochen.nlp.datastructure.DTree;
import org.maochen.nlp.datastructure.LangTools;
import org.maochen.nlp.parser.StanfordParserUtils;
import org.maochen.nlp.parser.stanford.StanfordParser;

public class StanfordNNDepParser
extends StanfordParser {
    public static DependencyParser nndepParser = null;

    private GrammaticalStructure tagDependencies(List<? extends HasWord> taggedWords) {
        GrammaticalStructure gs = nndepParser.predict(taggedWords);
        return gs;
    }

    @Override
    public DTree parse(String sentence) {
        List<CoreLabel> tokenizedSentence = StanfordNNDepParser.stanfordTokenize(sentence);
        this.tagPOS(tokenizedSentence);
        StanfordNNDepParser.tagLemma(tokenizedSentence);
        GrammaticalStructure gs = this.tagDependencies(tokenizedSentence);
        this.tagNamedEntity(tokenizedSentence);
        String conllXString = StanfordParserUtils.getCoNLLXString(gs.typedDependencies(), tokenizedSentence);
        DTree depTree = LangTools.getDTreeFromCoNLLXString((String)conllXString);
        return depTree;
    }

    public StanfordNNDepParser() {
        this(null, null, false);
    }

    public StanfordNNDepParser(String inputModelPath, String posTaggerModel, boolean initNER) {
        String modelPath = inputModelPath == null || inputModelPath.trim().isEmpty() ? "edu/stanford/nlp/models/parser/nndep/english_UD.gz" : inputModelPath;
        nndepParser = DependencyParser.loadFromModelFile((String)modelPath);
        super.load(posTaggerModel, initNER);
    }

    public static void main(String[] args) {
        StanfordNNDepParser parser = new StanfordNNDepParser("edu/stanford/nlp/models/parser/nndep/english_UD.gz", null, false);
        String text = "I went to the store and buy a car.";
        DTree tree = parser.parse(text);
        System.out.println(parser.parse(text).toString());
    }
}

