/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.nn;

import edu.stanford.nlp.io.ExtensionFileFilter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalPOSMapper;
import java.io.FileFilter;
import org.maochen.nlp.parser.StanfordParserUtils;

public class StanfordNNParserTrainer {
    public static final String conllXTrainFile = "/Users/Maochen/Desktop/train.conllx.txt";
    public static final String modelPath = "/Users/Maochen/Desktop/nndep.ser.gz";
    public static final String WSJ = "/Users/Maochen/Desktop/treebank_3/parsed/mrg/wsj";
    public static final String extra = "/Users/Maochen/Desktop/extra/treebank_extra_data/";

    public static void train() {
        ExtensionFileFilter filter = new ExtensionFileFilter(".mrg", true);
        StanfordParserUtils.convertTreebankToCoNLLX("/Users/Maochen/Desktop/extra/treebank_extra_data/maochen_hand_parsed/wsj_2502.mrg", (FileFilter)filter, conllXTrainFile);
    }

    public static void getCPosTag() {
        DiskTreebank treeBank = new DiskTreebank();
        treeBank.loadPath("/Users/Maochen/Desktop/temp.txt");
        Tree tree = (Tree)treeBank.iterator().next();
        System.out.println(tree.pennString());
        Tree uposTree = UniversalPOSMapper.mapTree((Tree)tree);
        System.out.println(uposTree.pennString());
    }

    public static void main(String[] args) {
        StanfordNNParserTrainer.train();
    }
}

