/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.chunker;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.maochen.nlp.app.featextractor.BrownFeatExtractor;
import org.maochen.nlp.app.featextractor.IFeatureExtractor;
import org.maochen.nlp.ml.SequenceTuple;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.vector.FeatNamedVector;
import org.maochen.nlp.ml.vector.IVector;

public class ChunkerFeatureExtractor
implements IFeatureExtractor {
    public static final int WORD_INDEX = 0;
    public static final int POS_INDEX = 1;

    public List<String> extractFeatSingle(int i, String[] tokens, String[] pos) {
        ArrayList<String> currentFeats = new ArrayList<String>();
        for (int index = Math.max(0, i - 2); index < Math.min(i + 3, tokens.length); ++index) {
            IFeatureExtractor.addFeat(currentFeats, "w" + (index - i), tokens[index]);
            IFeatureExtractor.addFeat(currentFeats, "pos" + (index - i), pos[index]);
            if (index == i - 1) {
                IFeatureExtractor.addFeat(currentFeats, "w-10", tokens[i - 1], tokens[i]);
                IFeatureExtractor.addFeat(currentFeats, "pos-10", pos[i - 1], pos[i]);
            } else if (index == i + 1) {
                IFeatureExtractor.addFeat(currentFeats, "w0+1", tokens[i], tokens[i + 1]);
                IFeatureExtractor.addFeat(currentFeats, "pos0+1", pos[i], pos[i + 1]);
            } else if (index == i - 2) {
                IFeatureExtractor.addFeat(currentFeats, "pos-2-1", pos[i - 2], pos[i - 1]);
                IFeatureExtractor.addFeat(currentFeats, "pos-2-10", pos[i - 2], pos[i - 1], pos[i]);
            } else if (index == i + 2) {
                IFeatureExtractor.addFeat(currentFeats, "pos+1+2", pos[i + 1], pos[i + 2]);
            }
            if (index == i - 1 && i < tokens.length - 1) {
                IFeatureExtractor.addFeat(currentFeats, "pos-10+1", pos[i - 1], pos[i], pos[i + 1]);
            }
            if (index != i + 2) continue;
            IFeatureExtractor.addFeat(currentFeats, "pos0+1+2", pos[i], pos[i + 1], pos[i + 2]);
        }
        currentFeats.addAll(BrownFeatExtractor.extractBrownFeat(i, -2, 2, tokens));
        return currentFeats;
    }

    @Override
    public List<Tuple> extractFeat(SequenceTuple entry) {
        String[] tokens = (String[])entry.entries.stream().map(tuple -> ((FeatNamedVector)tuple.vector).featsName[0]).toArray(String[]::new);
        String[] pos = (String[])entry.entries.stream().map(tuple -> ((FeatNamedVector)tuple.vector).featsName[1]).toArray(String[]::new);
        List feats = IntStream.range(0, tokens.length).mapToObj(i -> this.extractFeatSingle(i, tokens, pos)).collect(Collectors.toList());
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i2 = 0; i2 < feats.size(); ++i2) {
            List singleTokenFeat = (List)feats.get(i2);
            FeatNamedVector v = new FeatNamedVector((String[])singleTokenFeat.stream().toArray(String[]::new));
            Tuple t = new Tuple((IVector)v);
            t.label = ((Tuple)entry.entries.get((int)i2)).label;
            tuples.add(t);
        }
        return tuples;
    }
}

