/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.relationextract;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.maochen.nlp.commons.BinRelation;
import org.maochen.nlp.commons.Entity;
import org.maochen.nlp.parser.DNode;

public class RelExtUtils {
    public static Set<DNode> bfs(DNode root) {
        HashSet<DNode> result = new HashSet<DNode>();
        LinkedList<DNode> q = new LinkedList<DNode>();
        q.add(root);
        while (!q.isEmpty()) {
            DNode current = (DNode)q.poll();
            result.add(current);
            q.addAll(current.getChildren());
        }
        return result;
    }

    public static void annotateEntityNameByNode(Entity<DNode> entity) {
        entity.suggestedName = entity.stream().map(DNode::getForm).reduce((x1, x2) -> x1 + " " + x2).orElse("");
    }

    public static List<BinRelation> extractRel(DNode predicateNode) {
        HashSet<DNode> usedNodes = new HashSet<DNode>();
        ArrayList<Entity> resolvedEntities = new ArrayList<Entity>();
        List children = predicateNode.getChildren().stream().filter(x -> !x.getDepLabel().equals("punct")).filter(x -> !x.getDepLabel().startsWith("aux")).collect(Collectors.toList());
        for (DNode childEntity : children) {
            if (usedNodes.contains(childEntity)) continue;
            Set<DNode> entityNodes = RelExtUtils.bfs(childEntity);
            usedNodes.addAll(entityNodes);
            List entityNodesList = entityNodes.stream().sorted((n1, n2) -> Integer.compare(n1.getId(), n2.getId())).collect(Collectors.toList());
            Entity entity = new Entity();
            entity.addAll(entityNodesList);
            RelExtUtils.annotateEntityNameByNode((Entity<DNode>)entity);
            resolvedEntities.add(entity);
        }
        ArrayList<BinRelation> result = new ArrayList<BinRelation>();
        for (int i = 0; i < resolvedEntities.size(); ++i) {
            Entity thisEntity = (Entity)resolvedEntities.get(i);
            for (int j = i + 1; j < resolvedEntities.size(); ++j) {
                Entity thatEntity = (Entity)resolvedEntities.get(j);
                BinRelation binRelation = new BinRelation();
                binRelation.setLeft(thisEntity);
                binRelation.setRight(thatEntity);
                binRelation.setRel(predicateNode.getLemma());
                binRelation.feats.put("rel_original_word", predicateNode.getForm());
                binRelation.feats.put("pos", predicateNode.getPOS());
                result.add(binRelation);
            }
        }
        return result;
    }
}

