/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.coref;

import edu.stanford.nlp.coref.CorefAlgorithm;
import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.DocumentMaker;
import edu.stanford.nlp.coref.data.InputDoc;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.neural.NeuralCorefAlgorithm;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StanfordCoref {
    private final CorefAlgorithm corefAlgorithm;
    private final Dictionaries dictionaries;
    private Properties props;

    public StanfordCoref() {
        try {
            this.props = new Properties();
            this.dictionaries = new Dictionaries();
            this.corefAlgorithm = new NeuralCorefAlgorithm(this.props, this.dictionaries);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public List<String> getCoref(List<String> texts) {
        Document document;
        Properties props = new Properties();
        props.put("annotators", "tokenize, ssplit, pos, lemma, ner, parse, mention");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String text = texts.stream().collect(Collectors.joining(" "));
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        InputDoc inputDoc = new InputDoc(annotation);
        try {
            DocumentMaker documentMaker = new DocumentMaker(props, new Dictionaries());
            document = documentMaker.makeDocument(inputDoc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.corefAlgorithm.runCoref(document);
        HashMap pronToNoun = new HashMap();
        document.corefClusters.values().forEach(x -> x.corefMentions.forEach(mentionEntity -> {
            if (mentionEntity.mentionType == Dictionaries.MentionType.PRONOMINAL) {
                pronToNoun.put(mentionEntity, x.representative);
            }
        }));
        return ((List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(singleSentence -> {
            List mentions = (List)singleSentence.get(CorefCoreAnnotations.CorefMentionsAnnotation.class);
            HashMap<CoreLabel, String> tokenToWord = new HashMap<CoreLabel, String>();
            for (Mention mention : mentions) {
                if (!pronToNoun.containsKey(mention)) continue;
                tokenToWord.put(mention.headIndexedWord.backingLabel(), ((Mention)pronToNoun.get((Object)mention)).headString);
            }
            return ((List)singleSentence.get(CoreAnnotations.TokensAnnotation.class)).stream().map(token -> {
                if (tokenToWord.containsKey(token)) {
                    String word = (String)tokenToWord.get(token);
                    if ((Integer)token.get(CoreAnnotations.IndexAnnotation.class) == 1) {
                        word = StringUtils.capitalize((String)word);
                    }
                    return word;
                }
                return (String)token.get(CoreAnnotations.TextAnnotation.class);
            }).collect(Collectors.joining(" "));
        }).collect(Collectors.toList());
    }
}

