/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.nn;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.trees.GrammaticalStructure;
import java.util.List;
import org.maochen.nlp.parser.DTree;
import org.maochen.nlp.parser.stanford.StanfordParser;
import org.maochen.nlp.parser.stanford.util.StanfordParserUtils;

public class StanfordNNDepParser
extends StanfordParser {
    public DependencyParser nndepParser;

    private GrammaticalStructure tagDependencies(List<? extends HasWord> taggedWords) {
        GrammaticalStructure gs = this.nndepParser.predict(taggedWords);
        return gs;
    }

    @Override
    public DTree parse(String sentence) {
        if (sentence == null || sentence.trim().isEmpty()) {
            return null;
        }
        List<CoreLabel> tokenizedSentence = StanfordNNDepParser.stanfordTokenize(sentence);
        this.tagPOS(tokenizedSentence);
        StanfordNNDepParser.tagLemma(tokenizedSentence);
        GrammaticalStructure gs = this.tagDependencies(tokenizedSentence);
        this.tagNamedEntity(tokenizedSentence);
        DTree dTree = StanfordParserUtils.getDTreeFromCoreNLP(gs.typedDependencies(), tokenizedSentence);
        return dTree;
    }

    public StanfordNNDepParser() {
        this(null, null, null);
    }

    public StanfordNNDepParser(String inputModelPath, String posTaggerModel, List<String> nerModelPath) {
        String modelPath = inputModelPath == null || inputModelPath.trim().isEmpty() ? "edu/stanford/nlp/models/parser/nndep/english_UD.gz" : inputModelPath;
        this.nndepParser = DependencyParser.loadFromModelFile((String)modelPath);
        super.load(posTaggerModel, nerModelPath);
    }
}

