/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.pcfg;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.TypedDependency;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.maochen.nlp.parser.DNode;
import org.maochen.nlp.parser.DTree;
import org.maochen.nlp.parser.LangTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StanfordTreeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(StanfordTreeBuilder.class);

    private static void patchTree(DNode node) {
        if (node.getLemma().equalsIgnoreCase("-LRB-")) {
            node.setForm("(");
        } else if (node.getLemma().equalsIgnoreCase("-RRB-")) {
            node.setForm(")");
        }
        if (node.getDepLabel().equals("number")) {
            node.setDepLabel("num");
        }
    }

    private static void convertCopHead(DTree tree) {
        if (tree.getRoots().isEmpty()) {
            return;
        }
        DNode originalRoot = (DNode)tree.getRoots().get(0);
        List cops = originalRoot.getChildrenByDepLabels(new String[]{"cop"});
        if (!originalRoot.getPOS().startsWith("VB") && !cops.isEmpty() && cops.get(0) != originalRoot) {
            DNode cop = (DNode)cops.get(0);
            cop.setDepLabel("root");
            if (originalRoot.getDepLabel().equals("root")) {
                originalRoot.setDepLabel("dep");
            }
            cop.setHead(tree.getPaddingNode());
            originalRoot.setHead(cop);
            tree.getPaddingNode().removeChild(originalRoot.getId());
            tree.getPaddingNode().addChild(cop);
            for (DNode child : originalRoot.getChildren()) {
                if (child.getPOS().equals("IN")) continue;
                originalRoot.removeChild(child.getId());
                if (child == cop) continue;
                cop.addChild(child);
                child.setHead(cop);
            }
            cop.addChild(originalRoot);
        }
    }

    public static DTree generate(List<CoreLabel> tokens, Collection<TypedDependency> dependencies, List<Label> cPOSTag) {
        DTree depTree = new DTree();
        for (int i = 0; i < tokens.size(); ++i) {
            CoreLabel token = tokens.get(i);
            String cPOSTagValue = cPOSTag == null ? LangTools.getCPOSTag((String)token.tag()) : cPOSTag.get(i).value();
            String form = token.originalText() == null || token.originalText().trim().isEmpty() ? (String)token.get(CoreAnnotations.TextAnnotation.class) : token.originalText();
            String lemma = token.lemma() == null || token.lemma().trim().isEmpty() ? (String)token.get(CoreAnnotations.TextAnnotation.class) : token.lemma();
            DNode node2 = new DNode(i + 1, form, lemma, cPOSTagValue, token.tag(), "");
            node2.addFeature("index_start", String.valueOf(token.beginPosition()));
            node2.addFeature("index_end", String.valueOf(token.endPosition()));
            depTree.add(node2);
            StanfordTreeBuilder.setNamedEntity(node2, token);
        }
        dependencies.parallelStream().filter(td -> td.gov().index() != -1).forEach(td -> {
            int sourceIndex = td.gov().index();
            int targetIndex = td.dep().index();
            String childDEPLabel = td.reln().toString();
            DNode child = (DNode)depTree.get(targetIndex);
            DNode parent = (DNode)depTree.get(sourceIndex);
            if (child == null) {
                LOG.error(parent.getForm() + " doesn't have proper child.");
            } else {
                if (child.getPOS().equals("POS") && !childDEPLabel.equals("possessive")) {
                    childDEPLabel = "possessive";
                    parent.setDepLabel("poss");
                }
                child.setDepLabel(childDEPLabel);
                child.setHead(parent);
                parent.addChild(child);
            }
        });
        depTree.stream().forEach(node -> {
            if (node.getDepLabel() == null) {
                if (node.getForm().matches("\\p{Punct}+")) {
                    DNode rootVerb = depTree.getRoots().stream().findFirst().orElse(null);
                    node.setDepLabel("punct");
                    node.setHead(rootVerb);
                    ((DNode)depTree.get(rootVerb.getId())).addChild(node);
                } else {
                    LOG.error("node does not have label. ->", (Object)node.toString());
                }
            }
            StanfordTreeBuilder.patchTree(node);
            LangTools.generateLemma((DNode)node);
        });
        StanfordTreeBuilder.convertCopHead(depTree);
        StanfordTreeBuilder.swapPossessives(depTree);
        return depTree;
    }

    private static void swapPossessives(DTree depTree) {
        Predicate<DNode> pred = x -> {
            if (x.getHead() == null) {
                return false;
            }
            boolean needAlter = x.getHead().isRoot();
            return needAlter &= x.getPOS().startsWith("NN");
        };
        DNode originalParent = ((Stream)depTree.stream().parallel()).filter(pred).findFirst().orElse(null);
        if (originalParent == null) {
            return;
        }
        DNode possessiveChild = ((Stream)originalParent.getChildren().stream().parallel()).filter(x -> x.getLemma().equals("'s")).findFirst().orElse(null);
        if (possessiveChild == null) {
            return;
        }
        DNode nounChild = ((Stream)originalParent.getChildren().stream().parallel()).filter(x -> x.getPOS().startsWith("NN")).findFirst().orElse(null);
        if (nounChild == null) {
            return;
        }
        DNode det = originalParent.getChildrenByDepLabels(new String[]{"det"}).stream().findFirst().orElse(null);
        if (det != null) {
            originalParent.removeChild(det.getId());
            nounChild.addChild(det);
            det.setHead(nounChild);
        }
        DNode originalGrandParent = originalParent.getHead();
        originalParent.removeChild(nounChild.getId());
        originalGrandParent.removeChild(originalParent.getId());
        nounChild.setDepLabel(originalParent.getDepLabel());
        originalParent.setDepLabel("poss");
        nounChild.setHead(originalGrandParent);
        originalGrandParent.addChild(nounChild);
        originalParent.setHead(nounChild);
        nounChild.addChild(originalParent);
    }

    private static void setNamedEntity(DNode node, CoreLabel token) {
        if (token.ner() != null && !token.ner().equals("O")) {
            if (token.ner().equalsIgnoreCase("TIME") || token.ner().equalsIgnoreCase("DATE")) {
                String normalizedTime = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                if (normalizedTime != null) {
                    node.addFeature("time", normalizedTime);
                } else {
                    LOG.warn("Time NamedEntity but doesn't has proper parsed time. " + token.originalText());
                }
            }
            node.setNamedEntity(token.ner());
        }
    }
}

