/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.util.dataio;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.vector.FeatNamedVector;

public class CSVDataWriter {
    private String filename;
    private int labelCol;
    private String delim;
    private String header;
    public Set<Integer> excludingCols = new HashSet<Integer>();

    public void write(List<Tuple> trainingData, boolean writeFeatName, boolean writeFeatValue) throws IOException {
        int vecLength;
        if (!writeFeatName && !writeFeatValue) {
            throw new RuntimeException("At least one of the writeFeatName or writeFeatValue should be true.");
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(new File(this.filename)));
        StringBuilder stringBuilder = new StringBuilder();
        if (this.header != null && !this.header.trim().isEmpty()) {
            stringBuilder.append(this.header).append(System.lineSeparator());
        }
        if (this.labelCol > (vecLength = trainingData.iterator().next().vector.getVector().length) - 1 || this.labelCol < 0) {
            this.labelCol = vecLength;
        }
        int batchSize = 100;
        for (int countT = 0; countT < trainingData.size(); ++countT) {
            Tuple t = trainingData.get(countT);
            for (int i = 0; i < t.vector.getVector().length; ++i) {
                if (i == this.labelCol) {
                    stringBuilder.append(t.label).append(this.delim);
                }
                if (this.excludingCols.contains(i)) continue;
                if (t.vector instanceof FeatNamedVector && writeFeatName) {
                    FeatNamedVector lv = (FeatNamedVector)t.vector;
                    stringBuilder.append(lv.featsName[i]);
                    if (writeFeatValue) {
                        stringBuilder.append("=");
                    }
                }
                if (writeFeatValue) {
                    stringBuilder.append(t.vector.getVector()[i]);
                }
                stringBuilder.append(this.delim);
            }
            if (this.labelCol == vecLength) {
                stringBuilder.append(t.label);
            }
            if (stringBuilder.substring(stringBuilder.length() - 1, stringBuilder.length()).equals(this.delim)) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(System.lineSeparator());
            if (countT % batchSize != 0) continue;
            output.write(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        output.write(stringBuilder.toString().trim());
        output.close();
    }

    public CSVDataWriter(String filename, int labelCol, String delim, String header) {
        this.filename = filename;
        this.labelCol = labelCol;
        this.delim = delim;
        this.header = header;
    }
}

