/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.maproulette.client.api.IAPI;
import org.maproulette.client.connection.IMapRouletteConnection;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.connection.MapRouletteConnection;
import org.maproulette.client.connection.Query;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.model.Challenge;
import org.maproulette.client.model.Project;
import org.maproulette.client.utilities.ObjectMapperSingleton;

public class ProjectAPI
implements IAPI<Project> {
    private final ObjectMapper mapper = ObjectMapperSingleton.getMapper();
    private final IMapRouletteConnection connection;

    public ProjectAPI(MapRouletteConfiguration configuration) {
        this(new MapRouletteConnection(configuration));
    }

    public Optional<Project> get(String name) throws MapRouletteException {
        return this.get(-1L, name);
    }

    @Override
    public Optional<Project> get(long parentIdentifier, String name) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/projectByName/%s", name)).build();
        return this.parseResponse(this.connection.execute(query).orElse(""));
    }

    @Override
    public Optional<Project> get(long identifier) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/project/%s", identifier)).build();
        return this.parseResponse(this.connection.execute(query).orElse(""));
    }

    @Override
    public List<Project> find(String matcher, long parent, int limit, int page) throws MapRouletteException {
        Query query = Query.builder().get("/api/v2/projects/find").build();
        query.addParameter("q", matcher + "%");
        query.addParameter("parentId", "" + parent);
        query.addParameter("limit", "" + limit);
        query.addParameter("page", "" + page);
        query.addParameter("onlyEnabled", "false");
        String response = this.connection.execute(query).orElse("[]");
        try {
            return Arrays.asList((Project[])this.mapper.readValue(response, Project[].class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    public List<Challenge> children(long identifier, int limit, int page) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/project/%s/challenges", identifier)).build();
        query.addParameter("limit", "" + limit);
        query.addParameter("page", "" + page);
        String response = this.connection.execute(query).orElse("[]");
        try {
            return Arrays.asList((Challenge[])this.mapper.readValue(response, Challenge[].class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    @Override
    public Project create(Project project) throws MapRouletteException {
        try {
            Query query = Query.builder().post("/api/v2/project").data(this.mapper.writeValueAsString((Object)project)).build();
            return this.parseResponse(this.connection.execute(query).orElse("")).orElseThrow(() -> new MapRouletteException("Invalid response provided by update query."));
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteException(e);
        }
    }

    @Override
    public Project update(Project project) throws MapRouletteException {
        if (project.getId() < 0L) {
            throw new MapRouletteException(String.format("Invalid Id [%d] provided!", project.getId()));
        }
        try {
            Query query = Query.builder().put(String.format("/api/v2/project/%s", project.getId())).data(this.mapper.writeValueAsString((Object)project)).build();
            return this.parseResponse(this.connection.execute(query).orElse("")).orElseThrow(() -> new MapRouletteException("Invalid response provided by update query."));
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteException(e);
        }
    }

    @Override
    public boolean delete(long identifier) throws MapRouletteException {
        Query query = Query.builder().delete(String.format("/api/v2/project/%s", identifier)).build();
        this.connection.execute(query);
        return true;
    }

    @Override
    public boolean forceDelete(long identifier) throws MapRouletteException {
        Query query = Query.builder().delete(String.format("/api/v2/project/%s", identifier)).build();
        query.addParameter("immediate", "true");
        this.connection.execute(query);
        return true;
    }

    private Optional<Project> parseResponse(String response) throws MapRouletteException {
        if (StringUtils.isEmpty((String)response)) {
            return Optional.empty();
        }
        try {
            return Optional.of((Project)this.mapper.readValue(response, Project.class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    public ProjectAPI(IMapRouletteConnection connection) {
        this.connection = connection;
    }
}

