/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.maproulette.client.connection.IMapRouletteConnection;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.connection.MapRouletteConnection;
import org.maproulette.client.connection.Query;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.model.User;
import org.maproulette.client.utilities.ObjectMapperSingleton;

public class UserAPI {
    private final ObjectMapper mapper = ObjectMapperSingleton.getMapper();
    private final IMapRouletteConnection connection;

    public UserAPI(MapRouletteConfiguration configuration) {
        this(new MapRouletteConnection(configuration));
    }

    public Optional<User> getPublicFromId(long identifier) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/user/%d/public", identifier)).build();
        return this.parseResponse(this.connection.execute(query).orElse(""));
    }

    private Optional<User> parseResponse(String response) throws MapRouletteException {
        if (StringUtils.isEmpty((String)response)) {
            return Optional.empty();
        }
        try {
            return Optional.of((User)this.mapper.readValue(response, User.class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    public UserAPI(IMapRouletteConnection connection) {
        this.connection = connection;
    }
}

