/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.maproulette.client.api.ProjectAPI;
import org.maproulette.client.batch.ProjectBatch;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.Challenge;
import org.maproulette.client.model.Project;
import org.maproulette.client.model.Task;
import org.maproulette.client.utilities.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchUploader {
    private static final Logger logger = LoggerFactory.getLogger(BatchUploader.class);
    private final Map<Long, ProjectBatch> projectBatchMap = new HashMap<Long, ProjectBatch>();
    private final ProjectAPI projectAPI;
    private MapRouletteConfiguration configuration;
    private long defaultProjectIdentifier = -1L;

    public BatchUploader(MapRouletteConfiguration configuration) {
        this.configuration = configuration;
        this.projectAPI = new ProjectAPI(configuration);
    }

    public Tuple<Long, Long> addTasks(Challenge challenge, List<Task> tasks) throws MapRouletteException {
        Tuple<Long, Long> parents = new Tuple<Long, Long>(-1L, -1L);
        for (Task task : tasks) {
            parents = this.addTask(challenge, task);
        }
        return parents;
    }

    public Tuple<Long, Long> addTask(Challenge challenge, Task task) throws MapRouletteException {
        long identifier = challenge.getParent();
        if (identifier == -1L) {
            identifier = this.getDefaultProjectIdentifier();
        }
        long finalIdentifier = identifier;
        ProjectBatch projectBatch = this.projectBatchMap.computeIfAbsent(identifier, k -> new ProjectBatch(finalIdentifier, this.configuration));
        long challengeId = projectBatch.addTask(challenge, task);
        this.projectBatchMap.put(identifier, projectBatch);
        return new Tuple<Long, Long>(identifier, challengeId);
    }

    public void flush(long identifier) throws MapRouletteException {
        ProjectBatch projectBatch = this.projectBatchMap.get(identifier);
        if (projectBatch != null) {
            projectBatch.flush();
        }
    }

    public void flushAll() {
        this.projectBatchMap.forEach((identifier, batch) -> {
            try {
                logger.info("Flushing project {}", identifier);
                batch.flush();
            }
            catch (MapRouletteException e) {
                throw new MapRouletteRuntimeException(e);
            }
        });
    }

    private long getDefaultProjectIdentifier() throws MapRouletteException {
        if (this.defaultProjectIdentifier == -1L) {
            Optional<Project> defaultProject = this.projectAPI.get(this.configuration.getDefaultProjectName());
            this.defaultProjectIdentifier = defaultProject.isEmpty() ? this.projectAPI.create(Project.builder().name(this.configuration.getDefaultProjectName()).build()).getId() : defaultProject.get().getId();
        }
        return this.defaultProjectIdentifier;
    }
}

