/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.http;

import java.net.URI;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.http.DeleteResource;
import org.maproulette.client.http.GetResource;
import org.maproulette.client.http.HttpResource;
import org.maproulette.client.http.PostResource;
import org.maproulette.client.http.PutResource;

public class ResourceFactory {
    public HttpResource resource(String methodName, String uri) {
        return this.resource(methodName, URI.create(uri));
    }

    public HttpResource resource(String methodName, URI uri) {
        switch (methodName) {
            case "GET": {
                return new GetResource(uri);
            }
            case "DELETE": {
                return new DeleteResource(uri);
            }
            case "POST": {
                return new PostResource(uri);
            }
            case "PUT": {
                return new PutResource(uri);
            }
        }
        throw new MapRouletteRuntimeException(String.format("Invalid method name %s provided", methodName));
    }
}

