/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.StringUtils;

public enum TaskStatus {
    CREATED(0),
    FIXED(1),
    FALSE_POSITIVE(2),
    SKIPPED(3),
    DELETED(4),
    ALREADY_FIXED(5),
    TOO_HARD(6),
    ANSWERED(7),
    VALIDATED(8),
    DISABLED(9);

    private final int value;

    @JsonCreator
    public static TaskStatus fromValue(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return TaskStatus.fromValue(intValue);
        }
        catch (NumberFormatException e) {
            for (TaskStatus taskStatus : TaskStatus.values()) {
                if (!StringUtils.equalsIgnoreCase((String)taskStatus.name(), (String)value)) continue;
                return taskStatus;
            }
            return null;
        }
    }

    public static TaskStatus fromValue(int value) {
        for (TaskStatus status : TaskStatus.values()) {
            if (status.intValue() != value) continue;
            return status;
        }
        return null;
    }

    private TaskStatus(int value) {
        this.value = value;
    }

    @JsonValue
    public int intValue() {
        return this.value;
    }
}

