/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.batch;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.maproulette.client.api.ProjectAPI;
import org.maproulette.client.batch.ChallengeBatch;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.Challenge;
import org.maproulette.client.model.Project;
import org.maproulette.client.model.Task;
import org.maproulette.client.utilities.ThrowingConsumer;

public class ProjectBatch {
    private final Map<Long, ChallengeBatch> batch = new ConcurrentHashMap<Long, ChallengeBatch>();
    private final MapRouletteConfiguration configuration;
    private final long projectId;

    public ProjectBatch(long projectId, MapRouletteConfiguration configuration) {
        this.projectId = projectId;
        this.configuration = configuration;
    }

    public ProjectBatch(Project project, MapRouletteConfiguration configuration) {
        this.configuration = configuration;
        ProjectAPI projectAPI = new ProjectAPI(configuration);
        try {
            Optional<Project> batchProject = projectAPI.get(project.getName());
            if (batchProject.isEmpty()) {
                Project newProject = projectAPI.create(project);
                this.projectId = newProject.getId();
            } else {
                this.projectId = batchProject.get().getId();
            }
        }
        catch (MapRouletteException e) {
            throw new MapRouletteRuntimeException(e);
        }
    }

    public synchronized long addTask(Challenge challenge, Task task) throws MapRouletteException {
        challenge.setParent(this.projectId);
        long challengeId = ChallengeBatch.getChallengeId(this.configuration, challenge);
        ChallengeBatch challengeBatch = this.batch.getOrDefault(challengeId, new ChallengeBatch(this.configuration, challenge));
        task.setParent(challengeId);
        challengeBatch.addTask(task);
        this.batch.put(challengeId, challengeBatch);
        return challengeId;
    }

    public synchronized void flush(long challengeId) throws MapRouletteException {
        ChallengeBatch challengeBatch = this.batch.get(challengeId);
        if (challengeBatch != null) {
            challengeBatch.flush();
        }
    }

    public synchronized void flush() throws MapRouletteException {
        this.batch.keySet().forEach(ThrowingConsumer.throwingConsumerWrapper(key -> this.batch.get(key).flush()));
    }
}

