/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.PriorityRule;

public class RuleList
implements Serializable {
    private static final String KEY_CONDITION = "condition";
    private static final String KEY_RULES = "rules";
    private static final long serialVersionUID = -1085774480815117637L;
    private String condition;
    private List<PriorityRule> rules;

    public boolean isSet() {
        return this.condition != null && this.rules != null && !this.rules.isEmpty();
    }

    @JsonValue
    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return String.format("{\"%s\":\"%s\",\"%s\":%s}", KEY_CONDITION, this.getCondition(), KEY_RULES, mapper.writeValueAsString(this.getRules()));
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteRuntimeException(e);
        }
    }

    public static RuleListBuilder builder() {
        return new RuleListBuilder();
    }

    public String getCondition() {
        return this.condition;
    }

    public List<PriorityRule> getRules() {
        return this.rules;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setRules(List<PriorityRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleList)) {
            return false;
        }
        RuleList other = (RuleList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<PriorityRule> this$rules = this.getRules();
        List<PriorityRule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<PriorityRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public String toString() {
        return "RuleList(condition=" + this.getCondition() + ", rules=" + this.getRules() + ")";
    }

    public RuleList() {
    }

    public RuleList(String condition, List<PriorityRule> rules) {
        this.condition = condition;
        this.rules = rules;
    }

    public static class RuleListBuilder {
        private String condition;
        private List<PriorityRule> rules;

        RuleListBuilder() {
        }

        public RuleListBuilder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public RuleListBuilder rules(List<PriorityRule> rules) {
            this.rules = rules;
            return this;
        }

        public RuleList build() {
            return new RuleList(this.condition, this.rules);
        }

        public String toString() {
            return "RuleList.RuleListBuilder(condition=" + this.condition + ", rules=" + this.rules + ")";
        }
    }
}

