/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.connection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.apache.http.client.utils.URIBuilder;
import org.maproulette.client.connection.IMapRouletteConnection;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.connection.Query;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.http.HttpResource;
import org.maproulette.client.http.ResourceFactory;
import org.maproulette.client.utilities.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteConnection
implements IMapRouletteConnection {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapRouletteConnection.class);
    private static final int DEFAULT_CONNECTION_RETRIES = 3;
    private static final int DEFAULT_CONNECTION_WAIT = 5000;
    private static final String KEY_API_KEY = "apiKey";
    private final MapRouletteConfiguration configuration;
    private final URIBuilder uriBuilder;
    private final ResourceFactory resourceFactory;

    public MapRouletteConnection(MapRouletteConfiguration configuration, ResourceFactory factory) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration can't be null to create a connection.");
        }
        this.configuration = configuration;
        this.uriBuilder = new URIBuilder().setScheme(this.configuration.getScheme()).setHost(this.configuration.getServer()).setPort(this.configuration.getPort());
        this.resourceFactory = factory;
        if (!this.isAbleToConnectToMapRoulette()) {
            throw new IllegalArgumentException("configuration must be able to connect to MapRouletteServers to create a connection.");
        }
    }

    public MapRouletteConnection(MapRouletteConfiguration configuration) {
        this(configuration, new ResourceFactory());
    }

    @Override
    public Optional<String> execute(Query query) throws MapRouletteException {
        log.debug("Request: {} {}", (Object)query.getMethodName(), (Object)query.getUri());
        if (log.isTraceEnabled()) {
            log.trace("data={}", (Object)query.getData());
        }
        query.addHeader(KEY_API_KEY, this.configuration.getApiKey());
        return query.execute(this.resourceFactory, this.uriBuilder, ThrowingFunction.throwingFunctionWrapper(resource -> {
            int statusCode = resource.getStatusCode();
            log.trace("Response code: {} ", (Object)statusCode);
            switch (statusCode) {
                case 200: 
                case 201: {
                    String ret = resource.getResponseBodyAsString();
                    log.trace("Response body: {}", (Object)ret);
                    return ret;
                }
                case 204: 
                case 404: {
                    return "";
                }
            }
            throw new MapRouletteException(String.format("Invalid response status code %d - %s", statusCode, resource.getResponseBodyAsString()));
        }));
    }

    @Override
    public boolean isAbleToConnectToMapRoulette() {
        int retries = 0;
        while (true) {
            try {
                URI uri = this.uriBuilder.setPath("/ping").build();
                HttpResource homepage = this.resourceFactory.resource("GET", uri);
                int statusCode = homepage.getStatusCode();
                if (statusCode != 200) {
                    throw new MapRouletteException(String.format("Failed to connect to Map Roulette server [%s]. StatusCode: %d", uri.toString(), statusCode));
                }
                return true;
            }
            catch (Exception e) {
                log.error(String.format("Failed to connect to MapRoulette [%s]", this.configuration), (Throwable)e);
                if (++retries > 3) {
                    return false;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException exception) {
                    throw new MapRouletteRuntimeException(exception);
                }
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MapRouletteConfiguration getConfiguration() {
        return this.configuration;
    }
}

