/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.ChallengePriority;
import org.maproulette.client.model.IMapRouletteObject;
import org.maproulette.client.model.PointInformation;
import org.maproulette.client.model.TaskStatus;
import org.maproulette.client.utilities.ObjectMapperSingleton;
import org.maproulette.client.utilities.Utilities;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
implements IMapRouletteObject,
Serializable {
    private static final int CONSTANT_HASHCODE = 31;
    private static final long serialVersionUID = 3111348272637323920L;
    private long id;
    private long parent;
    private String name;
    private String instruction;
    private JsonNode location;
    private TaskStatus status;
    private ChallengePriority priority;
    private JsonNode geometries;
    private List<String> tags;
    private Long completedBy;
    private Long completedTimeSpent;
    private String mappedOn;
    private String errorTags;

    public static TaskBuilder builder(long parentIdentifier, String name) {
        return Task.taskBuilder().parent(parentIdentifier).name(name);
    }

    public static Task fromJson(String json) throws MapRouletteException {
        return Utilities.fromJson(json, Task.class);
    }

    public TaskBuilder toBuilder(boolean resetGeometry) {
        if (resetGeometry) {
            return this.toBuilder().resetGeometry();
        }
        return this.toBuilder();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Task) {
            Task task2 = (Task)obj;
            if (this.getId() == -1L || task2.getId() == -1L) {
                return StringUtils.equals((String)this.name, (String)task2.getName()) && this.getParent() == task2.getParent();
            }
            if (this.getId() == task2.getId()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.id != -1L) {
            return Long.hashCode(this.id);
        }
        int result = 31 + this.name.hashCode();
        return 31 * result + Long.hashCode(this.parent);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TaskBuilder taskBuilder() {
        return new TaskBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TaskBuilder toBuilder() {
        return new TaskBuilder().id(this.id).parent(this.parent).name(this.name).instruction(this.instruction).location(this.location).status(this.status).priority(this.priority).geometries(this.geometries).tags(this.tags).completedBy(this.completedBy).completedTimeSpent(this.completedTimeSpent).mappedOn(this.mappedOn).errorTags(this.errorTags);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getId() {
        return this.id;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getParent() {
        return this.parent;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInstruction() {
        return this.instruction;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonNode getLocation() {
        return this.location;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TaskStatus getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChallengePriority getPriority() {
        return this.priority;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonNode getGeometries() {
        return this.geometries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getCompletedBy() {
        return this.completedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getCompletedTimeSpent() {
        return this.completedTimeSpent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMappedOn() {
        return this.mappedOn;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getErrorTags() {
        return this.errorTags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setParent(long parent) {
        this.parent = parent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLocation(JsonNode location) {
        this.location = location;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPriority(ChallengePriority priority) {
        this.priority = priority;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGeometries(JsonNode geometries) {
        this.geometries = geometries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCompletedBy(Long completedBy) {
        this.completedBy = completedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCompletedTimeSpent(Long completedTimeSpent) {
        this.completedTimeSpent = completedTimeSpent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMappedOn(String mappedOn) {
        this.mappedOn = mappedOn;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setErrorTags(String errorTags) {
        this.errorTags = errorTags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Task(id=" + this.getId() + ", parent=" + this.getParent() + ", name=" + this.getName() + ", instruction=" + this.getInstruction() + ", location=" + this.getLocation() + ", status=" + this.getStatus() + ", priority=" + this.getPriority() + ", geometries=" + this.getGeometries() + ", tags=" + this.getTags() + ", completedBy=" + this.getCompletedBy() + ", completedTimeSpent=" + this.getCompletedTimeSpent() + ", mappedOn=" + this.getMappedOn() + ", errorTags=" + this.getErrorTags() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Task() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Task(long id, long parent, String name, String instruction, JsonNode location, TaskStatus status, ChallengePriority priority, JsonNode geometries, List<String> tags, Long completedBy, Long completedTimeSpent, String mappedOn, String errorTags) {
        this.id = id;
        this.parent = parent;
        this.name = name;
        this.instruction = instruction;
        this.location = location;
        this.status = status;
        this.priority = priority;
        this.geometries = geometries;
        this.tags = tags;
        this.completedBy = completedBy;
        this.completedTimeSpent = completedTimeSpent;
        this.mappedOn = mappedOn;
        this.errorTags = errorTags;
    }

    public static class TaskBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long parent;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String instruction;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private JsonNode location;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TaskStatus status;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ChallengePriority priority;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private JsonNode geometries;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<String> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Long completedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Long completedTimeSpent;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String mappedOn;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String errorTags;
        private static final String TASK_TYPE = "type";
        private static final String TASK_FEATURES = "features";
        private static final String TASK_FEATURE_COORDINATES = "coordinates";
        private static final String TASK_FEATURE_GEOMETRY = "geometry";
        private static final String KEY_DESCRIPTION = "description";
        private static final String TASK_FEATURE_PROPERTIES = "properties";
        private static final String FEATURE = "feature";
        private static final String POINT = "point";
        private final ObjectMapper mapper = ObjectMapperSingleton.getMapper();
        private final Set<PointInformation> points = new HashSet<PointInformation>();
        private ArrayNode geoJson = this.mapper.createArrayNode();

        public TaskBuilder locationGeojson(String geojson) {
            try {
                this.location = this.mapper.readTree(geojson);
            }
            catch (IOException e) {
                throw new MapRouletteRuntimeException(e);
            }
            return this;
        }

        public TaskBuilder addPoint(PointInformation point) {
            this.points.add(point);
            return this;
        }

        public TaskBuilder addPoints(List<PointInformation> points) {
            this.points.addAll(points);
            return this;
        }

        public TaskBuilder addGeojson(String geojson) {
            try {
                this.geoJson.add(this.mapper.readTree(geojson));
            }
            catch (IOException e) {
                throw new MapRouletteRuntimeException(e);
            }
            return this;
        }

        public TaskBuilder addErrorTags(String errorTags) {
            this.errorTags = errorTags;
            return this;
        }

        public TaskBuilder resetGeometry() {
            this.geoJson = this.mapper.createArrayNode();
            this.geometries = null;
            return this;
        }

        public TaskBuilder addGeojson(List<String> geojson) {
            geojson.forEach(arg_0 -> ((ArrayNode)this.geoJson).add(arg_0));
            return this;
        }

        public Task build() {
            try {
                if (this.geometries == null) {
                    this.geometries(this.buildGeometries());
                }
            }
            catch (MapRouletteException e) {
                throw new MapRouletteRuntimeException(e);
            }
            if (this.id < 1L) {
                this.id(-1L);
            }
            if (this.parent < 1L) {
                this.parent(-1L);
            }
            if (this.errorTags == null) {
                this.errorTags = "";
            }
            return new Task(this.id, this.parent, this.name, this.instruction, this.location, this.status, this.priority, this.geometries, this.tags, null, null, null, this.errorTags);
        }

        protected ArrayNode generateTaskFeatures(Set<PointInformation> source, ArrayNode geoJson) throws MapRouletteException {
            ArrayNode features = this.mapper.createArrayNode();
            if (source.isEmpty() && geoJson.size() == 0) {
                throw new MapRouletteException(String.format("Could not find any features for the task [%s].", this.toString()));
            }
            source.forEach(point -> {
                ObjectNode feature = this.mapper.createObjectNode();
                ObjectNode geometry = this.mapper.createObjectNode();
                ArrayNode coordinates = this.mapper.createArrayNode();
                coordinates.add(point.getLongitude());
                coordinates.add(point.getLatitude());
                geometry.put(TASK_TYPE, POINT);
                geometry.set(TASK_FEATURE_COORDINATES, (JsonNode)coordinates);
                feature.set(TASK_FEATURE_GEOMETRY, (JsonNode)geometry);
                feature.put(TASK_TYPE, FEATURE);
                ObjectNode pointInformation = this.mapper.createObjectNode();
                if (StringUtils.isEmpty((String)point.getDescription())) {
                    pointInformation.put(KEY_DESCRIPTION, point.getDescription());
                }
                feature.set(TASK_FEATURE_PROPERTIES, (JsonNode)pointInformation);
                features.add((JsonNode)feature);
            });
            if (geoJson != null) {
                geoJson.forEach(arg_0 -> ((ArrayNode)features).add(arg_0));
            }
            return features;
        }

        private TaskBuilder location(JsonNode value) {
            this.location = value;
            return this;
        }

        private TaskBuilder geometries(JsonNode value) {
            this.geometries = value;
            return this;
        }

        private JsonNode buildGeometries() throws MapRouletteException {
            ObjectNode result = this.mapper.createObjectNode();
            result.set(TASK_FEATURES, (JsonNode)this.generateTaskFeatures(this.points, this.geoJson));
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TaskBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder id(long id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder parent(long parent) {
            this.parent = parent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder priority(ChallengePriority priority) {
            this.priority = priority;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder completedBy(Long completedBy) {
            this.completedBy = completedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder completedTimeSpent(Long completedTimeSpent) {
            this.completedTimeSpent = completedTimeSpent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder mappedOn(String mappedOn) {
            this.mappedOn = mappedOn;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskBuilder errorTags(String errorTags) {
            this.errorTags = errorTags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Task.TaskBuilder(id=" + this.id + ", parent=" + this.parent + ", name=" + this.name + ", instruction=" + this.instruction + ", location=" + this.location + ", status=" + this.status + ", priority=" + this.priority + ", geometries=" + this.geometries + ", tags=" + this.tags + ", completedBy=" + this.completedBy + ", completedTimeSpent=" + this.completedTimeSpent + ", mappedOn=" + this.mappedOn + ", errorTags=" + this.errorTags + ")";
        }
    }
}

