/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.maproulette.client.api.IAPI;
import org.maproulette.client.connection.IMapRouletteConnection;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.connection.MapRouletteConnection;
import org.maproulette.client.connection.Query;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.model.Challenge;
import org.maproulette.client.model.Task;
import org.maproulette.client.utilities.ObjectMapperSingleton;

public class ChallengeAPI
implements IAPI<Challenge> {
    private final ObjectMapper mapper = ObjectMapperSingleton.getMapper();
    private final IMapRouletteConnection connection;

    public ChallengeAPI(MapRouletteConfiguration configuration) {
        this(new MapRouletteConnection(configuration));
    }

    @Override
    public Optional<Challenge> get(long parentIdentifier, String name) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/project/%d/challenge/%s", parentIdentifier, name)).build();
        return this.parseResponse(this.connection.execute(query).orElse(""));
    }

    @Override
    public Optional<Challenge> get(long identifier) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/challenge/%s", identifier)).build();
        return this.parseResponse(this.connection.execute(query).orElse(""));
    }

    @Override
    public List<Challenge> find(String matcher, long parent, int limit, int page) throws MapRouletteException {
        Query query = Query.builder().get("/api/v2/challenges/find").build();
        query.addParameter("q", matcher + "%");
        query.addParameter("parentId", "" + parent);
        query.addParameter("limit", "" + limit);
        query.addParameter("page", "" + page);
        query.addParameter("onlyEnabled", "false");
        String response = this.connection.execute(query).orElse("[]");
        try {
            return Arrays.asList((Challenge[])this.mapper.readValue(response, Challenge[].class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    public List<Task> children(long identifier, int limit, int page) throws MapRouletteException {
        Query query = Query.builder().get(String.format("/api/v2/challenge/%s/tasks", identifier)).build();
        query.addParameter("limit", "" + limit);
        query.addParameter("page", "" + page);
        String response = this.connection.execute(query).orElse("[]");
        try {
            return Arrays.asList((Task[])this.mapper.readValue(response, Task[].class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    @Override
    public Challenge create(Challenge challenge) throws MapRouletteException {
        try {
            Query query = Query.builder().post("/api/v2/challenge").data(this.mapper.writeValueAsString((Object)challenge)).build();
            return this.parseResponse(this.connection.execute(query).orElse("")).orElseThrow(() -> new MapRouletteException("Invalid response provided by update query."));
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteException(e);
        }
    }

    @Override
    public Challenge update(Challenge challenge) throws MapRouletteException {
        if (challenge.getId() < 0L) {
            throw new MapRouletteException(String.format("Invalid Id [%d] provided!", challenge.getId()));
        }
        try {
            Query query = Query.builder().put(String.format("/api/v2/challenge/%s", challenge.getId())).data(this.mapper.writeValueAsString((Object)challenge)).build();
            return this.parseResponse(this.connection.execute(query).orElse("")).orElseThrow(() -> new MapRouletteException("Invalid response provided by update query."));
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteException(e);
        }
    }

    @Override
    public boolean delete(long identifier) throws MapRouletteException {
        Query query = Query.builder().delete(String.format("/api/v2/challenge/%s", identifier)).build();
        this.connection.execute(query);
        return true;
    }

    @Override
    public boolean forceDelete(long identifier) throws MapRouletteException {
        Query query = Query.builder().delete(String.format("/api/v2/challenge/%s", identifier)).build();
        query.addParameter("immediate", "true");
        this.connection.execute(query);
        return true;
    }

    private Optional<Challenge> parseResponse(String response) throws MapRouletteException {
        if (StringUtils.isEmpty((String)response)) {
            return Optional.empty();
        }
        try {
            return Optional.of((Challenge)this.mapper.readValue(response, Challenge.class));
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChallengeAPI(IMapRouletteConnection connection) {
        this.connection = connection;
    }
}

