/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.maproulette.client.exception.MapRouletteRuntimeParseException;

public final class PriorityRule
implements Serializable {
    private static final Set<String> NUMBER_COMPARISON_OPERATORS = Set.of("==", "!=", "<", "<=", ">", ">=");
    private static final Set<String> STRING_COMPARISON_OPERATORS = Set.of("equal", "not_equal", "contains", "not_contains", "is_empty", "is_not_empty");
    private static final Map<String, Set<String>> TYPE_TO_OPERATORS = Map.of("bounds", Set.of("contains", "not_contains"), "string", STRING_COMPARISON_OPERATORS, "integer", NUMBER_COMPARISON_OPERATORS, "long", NUMBER_COMPARISON_OPERATORS, "double", NUMBER_COMPARISON_OPERATORS);
    private static final long serialVersionUID = -7443371611488972313L;
    private final String value;
    private final String type;
    private final String operator;

    public static PriorityRuleBuilder builder() {
        return new PriorityRuleBuilderCustom();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    PriorityRule(String value, String type, String operator) {
        this.value = value;
        this.type = type;
        this.operator = operator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getValue() {
        return this.value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getOperator() {
        return this.operator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriorityRule)) {
            return false;
        }
        PriorityRule other = (PriorityRule)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "PriorityRule(value=" + this.getValue() + ", type=" + this.getType() + ", operator=" + this.getOperator() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class PriorityRuleBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String operator;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        PriorityRuleBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriorityRuleBuilder value(String value) {
            this.value = value;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriorityRuleBuilder type(String type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriorityRuleBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PriorityRule build() {
            return new PriorityRule(this.value, this.type, this.operator);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "PriorityRule.PriorityRuleBuilder(value=" + this.value + ", type=" + this.type + ", operator=" + this.operator + ")";
        }
    }

    private static class PriorityRuleBuilderCustom
    extends PriorityRuleBuilder {
        private PriorityRuleBuilderCustom() {
        }

        @Override
        public PriorityRule build() {
            if (!TYPE_TO_OPERATORS.containsKey(this.type)) {
                throw new MapRouletteRuntimeParseException(String.format("Type '%s' is not supported by Priority Rules", this.type));
            }
            if (!TYPE_TO_OPERATORS.get(this.type).contains(this.operator)) {
                throw new MapRouletteRuntimeParseException(String.format("Operator '%s' is not supported by type '%s'", this.operator, this.type));
            }
            if (this.value.split("\\.").length != 2) {
                throw new MapRouletteRuntimeParseException(String.format("value '%s' must contain exactly one '.'", this.value));
            }
            return new PriorityRule(this.value, this.type, this.operator);
        }
    }
}

