/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.maproulette.client.exception.MapRouletteRuntimeParseException;
import org.maproulette.client.model.PriorityRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=RuleListDeserializer.class)
@JsonSerialize(using=RuleListSerializer.class)
public final class RuleList
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RuleList.class);
    public static final String CONDITION_AND = "AND";
    public static final String CONDITION_OR = "OR";
    private static final Set<String> VALID_CONDITIONS = Set.of("AND", "OR");
    private static final String KEY_CONDITION = "condition";
    private static final String KEY_RULES = "rules";
    private static final long serialVersionUID = -1085774480815117637L;
    @NonNull
    private final String condition;
    @NonNull
    private final List<RuleList> ruleList;
    @NonNull
    private final List<PriorityRule> rules;

    public boolean isSet() {
        if (this.condition.isEmpty() && this.rules.isEmpty() && this.ruleList.isEmpty()) {
            return false;
        }
        return !this.rules.isEmpty() || !this.ruleList.isEmpty();
    }

    private static String $default$condition() {
        return "";
    }

    private static List<RuleList> $default$ruleList() {
        return new ArrayList<RuleList>();
    }

    private static List<PriorityRule> $default$rules() {
        return new ArrayList<PriorityRule>();
    }

    public static RuleListBuilder builder() {
        return new RuleListBuilder();
    }

    @NonNull
    public String getCondition() {
        return this.condition;
    }

    @NonNull
    public List<RuleList> getRuleList() {
        return this.ruleList;
    }

    @NonNull
    public List<PriorityRule> getRules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleList)) {
            return false;
        }
        RuleList other = (RuleList)o;
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<RuleList> this$ruleList = this.getRuleList();
        List<RuleList> other$ruleList = other.getRuleList();
        if (this$ruleList == null ? other$ruleList != null : !((Object)this$ruleList).equals(other$ruleList)) {
            return false;
        }
        List<PriorityRule> this$rules = this.getRules();
        List<PriorityRule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<RuleList> $ruleList = this.getRuleList();
        result = result * 59 + ($ruleList == null ? 43 : ((Object)$ruleList).hashCode());
        List<PriorityRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public String toString() {
        return "RuleList(condition=" + this.getCondition() + ", ruleList=" + this.getRuleList() + ", rules=" + this.getRules() + ")";
    }

    public RuleList() {
        this.condition = RuleList.$default$condition();
        this.ruleList = RuleList.$default$ruleList();
        this.rules = RuleList.$default$rules();
    }

    public RuleList(@NonNull String condition, @NonNull List<RuleList> ruleList, @NonNull List<PriorityRule> rules) {
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        if (ruleList == null) {
            throw new NullPointerException("ruleList is marked non-null but is null");
        }
        if (rules == null) {
            throw new NullPointerException("rules is marked non-null but is null");
        }
        this.condition = condition;
        this.ruleList = ruleList;
        this.rules = rules;
    }

    public static class RuleListBuilder {
        private boolean condition$set;
        private String condition$value;
        private boolean ruleList$set;
        private List<RuleList> ruleList$value;
        private boolean rules$set;
        private List<PriorityRule> rules$value;

        RuleListBuilder() {
        }

        public RuleListBuilder condition(@NonNull String condition) {
            if (condition == null) {
                throw new NullPointerException("condition is marked non-null but is null");
            }
            this.condition$value = condition;
            this.condition$set = true;
            return this;
        }

        public RuleListBuilder ruleList(@NonNull List<RuleList> ruleList) {
            if (ruleList == null) {
                throw new NullPointerException("ruleList is marked non-null but is null");
            }
            this.ruleList$value = ruleList;
            this.ruleList$set = true;
            return this;
        }

        public RuleListBuilder rules(@NonNull List<PriorityRule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules is marked non-null but is null");
            }
            this.rules$value = rules;
            this.rules$set = true;
            return this;
        }

        public RuleList build() {
            String condition$value = this.condition$value;
            if (!this.condition$set) {
                condition$value = RuleList.$default$condition();
            }
            List<RuleList> ruleList$value = this.ruleList$value;
            if (!this.ruleList$set) {
                ruleList$value = RuleList.$default$ruleList();
            }
            List<PriorityRule> rules$value = this.rules$value;
            if (!this.rules$set) {
                rules$value = RuleList.$default$rules();
            }
            return new RuleList(condition$value, ruleList$value, rules$value);
        }

        public String toString() {
            return "RuleList.RuleListBuilder(condition$value=" + this.condition$value + ", ruleList$value=" + this.ruleList$value + ", rules$value=" + this.rules$value + ")";
        }
    }

    public static class RuleListDeserializer
    extends StdDeserializer<RuleList> {
        public RuleListDeserializer() {
            this(null);
        }

        public RuleListDeserializer(Class<?> valueClass) {
            super(valueClass);
        }

        private static RuleList buildRuleListHelper(JsonNode node, DeserializationContext ctxt) {
            JsonNode conditionNode = node.get(RuleList.KEY_CONDITION);
            JsonNode rulesNode = node.get(RuleList.KEY_RULES);
            if (conditionNode == null && rulesNode == null) {
                return RuleList.builder().build();
            }
            if (conditionNode == null || rulesNode == null) {
                throw new MapRouletteRuntimeParseException("parse error: the rulelist requires both a 'condition' and 'rules' field");
            }
            if (!VALID_CONDITIONS.contains(conditionNode.asText())) {
                throw new MapRouletteRuntimeParseException(String.format("Condition '%s' is not known", conditionNode.asText()));
            }
            RuleListBuilder ret = RuleList.builder().condition(conditionNode.asText()).ruleList(new ArrayList<RuleList>()).rules(new ArrayList<PriorityRule>());
            for (JsonNode jsonNode : node.withArray(RuleList.KEY_RULES)) {
                if (jsonNode.get(RuleList.KEY_CONDITION) != null || jsonNode.get(RuleList.KEY_RULES) != null) {
                    RuleList child = RuleListDeserializer.buildRuleListHelper(jsonNode, ctxt);
                    ret.ruleList$value.add(child);
                    continue;
                }
                if (jsonNode.get("type") == null || jsonNode.get("operator") == null || jsonNode.get("value") == null) {
                    throw new MapRouletteRuntimeParseException("Nested object is not a PriorityRule nor a RuleList! Parsing failed!");
                }
                PriorityRule priorityRule = PriorityRule.builder().type(jsonNode.get("type").asText()).operator(jsonNode.get("operator").asText()).value(jsonNode.get("value").asText()).build();
                ret.rules$value.add(priorityRule);
            }
            return ret.build();
        }

        public RuleList deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jsonParser.readValueAsTree();
            if (tree.isContainerNode()) {
                return RuleListDeserializer.buildRuleListHelper(tree, ctxt);
            }
            String ruleListString = (String)jsonParser.getCodec().treeToValue((TreeNode)tree, String.class);
            JsonNode ruleListNode = ((ObjectMapper)jsonParser.getCodec()).readTree(ruleListString);
            return RuleListDeserializer.buildRuleListHelper(ruleListNode, ctxt);
        }
    }

    public static class RuleListSerializer
    extends StdSerializer<RuleList> {
        public RuleListSerializer() {
            this(null);
        }

        public RuleListSerializer(Class<RuleList> clazzRuleList) {
            super(clazzRuleList);
        }

        private static void serializeRuleListHelper(List<RuleList> ruleListList, JsonGenerator gen) throws IOException {
            for (RuleList ruleList : ruleListList) {
                String condition = ruleList.getCondition();
                if (!RuleList.CONDITION_AND.equals(condition) && !RuleList.CONDITION_OR.equals(condition)) {
                    throw new MapRouletteRuntimeParseException(String.format("Condition '%s' is not known", condition));
                }
                gen.writeStartObject();
                gen.writeStringField(RuleList.KEY_CONDITION, ruleList.getCondition());
                gen.writeArrayFieldStart(RuleList.KEY_RULES);
                for (RuleList nestedRuleList : ruleList.getRuleList()) {
                    RuleListSerializer.serializeRuleListHelper(nestedRuleList.getRuleList(), gen);
                }
                for (PriorityRule priorityRule : ruleList.getRules()) {
                    gen.writeObject((Object)priorityRule);
                }
                gen.writeEndArray();
                gen.writeEndObject();
            }
        }

        private void serializeRuleListAsObject(RuleList value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String condition = value.getCondition();
            if (!VALID_CONDITIONS.contains(condition)) {
                throw new MapRouletteRuntimeParseException(String.format("Condition '%s' is not known", condition));
            }
            gen.writeStartObject();
            gen.writeStringField(RuleList.KEY_CONDITION, condition);
            gen.writeArrayFieldStart(RuleList.KEY_RULES);
            RuleListSerializer.serializeRuleListHelper(value.getRuleList(), gen);
            for (PriorityRule priorityRule : value.getRules()) {
                gen.writeObject((Object)priorityRule);
            }
            gen.writeEndArray();
            gen.writeEndObject();
            gen.flush();
        }

        public void serialize(RuleList value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (!value.isSet()) {
                gen.writeString("{}");
                return;
            }
            StringWriter stringWriter = new StringWriter();
            JsonGenerator tempGen = new JsonFactory().setCodec(gen.getCodec()).createGenerator((Writer)stringWriter);
            this.serializeRuleListAsObject(value, tempGen, serializers);
            String ruleListAsString = stringWriter.toString();
            gen.writeString(ruleListAsString);
            stringWriter.close();
            tempGen.close();
        }
    }
}

