/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryManager;
import org.mapsforge.poi.storage.UnknownPoiCategoryException;
import org.mapsforge.poi.writer.jaxb.Category;
import org.mapsforge.poi.writer.jaxb.Mapping;

class TagMappingResolver {
    private static final Logger LOGGER = Logger.getLogger(TagMappingResolver.class.getName());
    private final PoiCategoryManager categoryManager;
    private final Map<String, List<String>> tagMap;
    private final Set<String> mappingTags;

    TagMappingResolver(URL configFilePath, PoiCategoryManager categoryManager) {
        this.categoryManager = categoryManager;
        this.tagMap = new HashMap<String, List<String>>();
        this.mappingTags = new TreeSet<String>();
        Category xmlRootCategory = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)"org.mapsforge.poi.writer.jaxb", (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller um = ctx.createUnmarshaller();
            xmlRootCategory = (Category)um.unmarshal(configFilePath);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "Could not load POI category configuration from XML.", e);
        }
        Stack<Category> categories = new Stack<Category>();
        categories.push(xmlRootCategory);
        while (!categories.isEmpty()) {
            for (Category c : ((Category)categories.pop()).getCategory()) {
                categories.push(c);
                for (Mapping m : c.getMapping()) {
                    String tag = m.getTag().toLowerCase(Locale.ENGLISH);
                    LOGGER.finer("'" + tag + "' --> '" + c.getTitle() + "'");
                    List<String> categoryTitles = this.tagMap.get(tag);
                    if (categoryTitles == null) {
                        categoryTitles = new ArrayList<String>();
                    }
                    categoryTitles.add(c.getTitle());
                    this.tagMap.put(tag, categoryTitles);
                }
            }
        }
        for (String tag : this.tagMap.keySet()) {
            this.mappingTags.add(tag.split("=")[0]);
        }
    }

    List<PoiCategory> getCategoriesFromTag(String tag) throws UnknownPoiCategoryException {
        List<String> categoryTitles = this.tagMap.get(tag = tag.toLowerCase(Locale.ENGLISH));
        if (categoryTitles == null) {
            return null;
        }
        ArrayList<PoiCategory> poiCategories = new ArrayList<PoiCategory>();
        for (String categoryTitle : categoryTitles) {
            PoiCategory poiCategory = this.categoryManager.getPoiCategoryByTitle(categoryTitle);
            if (poiCategory == null) continue;
            poiCategories.add(poiCategory);
        }
        return poiCategories;
    }

    Set<String> getMappingTags() {
        return this.mappingTags;
    }
}

