/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer.osmosis;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.mapsforge.poi.writer.PoiWriter;
import org.mapsforge.poi.writer.logging.LoggerWrapper;
import org.mapsforge.poi.writer.logging.ProgressManager;
import org.mapsforge.poi.writer.model.PoiWriterConfiguration;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class PoiWriterTask
implements Sink {
    private static final Logger LOGGER = LoggerWrapper.getLogger(PoiWriterTask.class.getName());
    private final PoiWriter poiWriter;

    public PoiWriterTask(PoiWriterConfiguration configuration, ProgressManager progressManager) {
        Properties properties = new Properties();
        try {
            properties.load(PoiWriterTask.class.getClassLoader().getResourceAsStream("mapsforge-poi.properties"));
            configuration.setWriterVersion("mapsforge-poi-writer-" + properties.getProperty("poi.writer.version"));
            configuration.setFileSpecificationVersion(Integer.parseInt(properties.getProperty("poi.specification.version")));
            LOGGER.info("POI writer version: " + configuration.getWriterVersion());
            LOGGER.info("POI format specification version: " + configuration.getFileSpecificationVersion());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find default properties", e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("POI format specification version is not an integer", e);
        }
        this.poiWriter = PoiWriter.newInstance(configuration, progressManager);
    }

    public void close() {
    }

    public void complete() {
        this.poiWriter.complete();
    }

    public void initialize(Map<String, Object> metadata) {
    }

    public void process(EntityContainer entityContainer) {
        this.poiWriter.process(entityContainer);
    }
}

