/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer.util;

public final class ArabicNormalizer {
    private static final String ARABIC_DIGITS = "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669";
    private static final String DIGITS_REPLACEMENT = "0123456789";

    public static boolean isSpecialArabic(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        char first = text.charAt(0);
        return Character.UnicodeBlock.of(first) == Character.UnicodeBlock.ARABIC;
    }

    public static String normalize(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String result = ArabicNormalizer.replaceCharacters(text);
        return ArabicNormalizer.replaceDigits(result);
    }

    private static String replaceCharacters(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        char first = text.charAt(0);
        if (Character.UnicodeBlock.of(first) != Character.UnicodeBlock.ARABIC) {
            return text;
        }
        text = text.replaceAll("\u0610", "");
        text = text.replaceAll("\u0611", "");
        text = text.replaceAll("\u0612", "");
        text = text.replaceAll("\u0613", "");
        text = text.replaceAll("\u0614", "");
        text = text.replaceAll("\u0615", "");
        text = text.replaceAll("\u0616", "");
        text = text.replaceAll("\u0617", "");
        text = text.replaceAll("\u0618", "");
        text = text.replaceAll("\u0619", "");
        text = text.replaceAll("\u061a", "");
        text = text.replaceAll("\u06d6", "");
        text = text.replaceAll("\u06d7", "");
        text = text.replaceAll("\u06d8", "");
        text = text.replaceAll("\u06d9", "");
        text = text.replaceAll("\u06da", "");
        text = text.replaceAll("\u06db", "");
        text = text.replaceAll("\u06dc", "");
        text = text.replaceAll("\u06dd", "");
        text = text.replaceAll("\u06de", "");
        text = text.replaceAll("\u06df", "");
        text = text.replaceAll("\u06e0", "");
        text = text.replaceAll("\u06e1", "");
        text = text.replaceAll("\u06e2", "");
        text = text.replaceAll("\u06e3", "");
        text = text.replaceAll("\u06e4", "");
        text = text.replaceAll("\u06e5", "");
        text = text.replaceAll("\u06e6", "");
        text = text.replaceAll("\u06e7", "");
        text = text.replaceAll("\u06e8", "");
        text = text.replaceAll("\u06e9", "");
        text = text.replaceAll("\u06ea", "");
        text = text.replaceAll("\u06eb", "");
        text = text.replaceAll("\u06ec", "");
        text = text.replaceAll("\u06ed", "");
        text = text.replaceAll("\u0640", "");
        text = text.replaceAll("\u064b", "");
        text = text.replaceAll("\u064c", "");
        text = text.replaceAll("\u064d", "");
        text = text.replaceAll("\u064e", "");
        text = text.replaceAll("\u064f", "");
        text = text.replaceAll("\u0650", "");
        text = text.replaceAll("\u0651", "");
        text = text.replaceAll("\u0652", "");
        text = text.replaceAll("\u0653", "");
        text = text.replaceAll("\u0654", "");
        text = text.replaceAll("\u0655", "");
        text = text.replaceAll("\u0656", "");
        text = text.replaceAll("\u0657", "");
        text = text.replaceAll("\u0658", "");
        text = text.replaceAll("\u0659", "");
        text = text.replaceAll("\u065a", "");
        text = text.replaceAll("\u065b", "");
        text = text.replaceAll("\u065c", "");
        text = text.replaceAll("\u065d", "");
        text = text.replaceAll("\u065e", "");
        text = text.replaceAll("\u065f", "");
        text = text.replaceAll("\u0670", "");
        text = text.replaceAll("\u0624", "\u0648");
        text = text.replaceAll("\u0629", "\u0647");
        text = text.replaceAll("\u064a", "\u0649");
        text = text.replaceAll("\u0626", "\u0649");
        text = text.replaceAll("\u0622", "\u0627");
        text = text.replaceAll("\u0623", "\u0627");
        text = text.replaceAll("\u0625", "\u0627");
        return text;
    }

    private static String replaceDigits(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        char first = text.charAt(0);
        if (Character.UnicodeBlock.of(first) != Character.UnicodeBlock.ARABIC) {
            return text;
        }
        char[] textChars = text.toCharArray();
        for (int i = 0; i < ARABIC_DIGITS.length(); ++i) {
            char c = ARABIC_DIGITS.charAt(i);
            char replacement = DIGITS_REPLACEMENT.charAt(i);
            int index = text.indexOf(c);
            while (index >= 0) {
                textChars[index] = replacement;
                index = text.indexOf(c, index + 1);
            }
        }
        return String.valueOf(textChars);
    }

    private ArabicNormalizer() {
    }
}

