/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer.logging;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.mapsforge.poi.writer.logging.ProgressManager;

public class LoggerWrapper
extends Logger {
    private static ProgressManager defaultProgressManager;
    private ProgressManager pm;

    private LoggerWrapper(String name) {
        super(name, null);
    }

    public static synchronized LoggerWrapper getLogger(String name) {
        LogManager lm = LogManager.getLogManager();
        Logger l = lm.getLogger(name);
        if (l == null) {
            lm.addLogger(new LoggerWrapper(name));
            ((LoggerWrapper)lm.getLogger(name)).setProgressManager(defaultProgressManager);
        }
        return (LoggerWrapper)lm.getLogger(name);
    }

    public static LoggerWrapper getLogger(String name, ProgressManager pm) {
        LoggerWrapper ret = LoggerWrapper.getLogger(name);
        if (ret.getProgressManager() == null || ret.getProgressManager() == defaultProgressManager) {
            ret.setProgressManager(pm);
        }
        return ret;
    }

    private synchronized ProgressManager getProgressManager() {
        return this.pm;
    }

    @Override
    public void log(Level level, String msg) {
        super.log(level, msg);
        this.pm.appendLogMessage(msg, false);
    }

    public static void setDefaultProgressManager(ProgressManager pm) {
        defaultProgressManager = pm;
    }

    public synchronized void setProgressManager(ProgressManager pm) {
        this.pm = pm;
    }
}

