/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.mapsforge.poi.storage.DoubleLinkedPoiCategory;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryManager;
import org.mapsforge.poi.writer.jaxb.Category;

class XMLPoiCategoryManager
implements PoiCategoryManager {
    private static final Logger LOGGER = Logger.getLogger(XMLPoiCategoryManager.class.getName());
    private final Map<String, DoubleLinkedPoiCategory> titleMap = new HashMap<String, DoubleLinkedPoiCategory>();
    private DoubleLinkedPoiCategory root = null;

    XMLPoiCategoryManager(URL configFilePath) {
        Category xmlRootCategory = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Category.class});
            Unmarshaller um = ctx.createUnmarshaller();
            xmlRootCategory = (Category)um.unmarshal(configFilePath);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "Could not load POI category configuration from XML.", e);
        }
        LinkedList<Category> currentXMLNode = new LinkedList<Category>();
        currentXMLNode.push(xmlRootCategory);
        while (!currentXMLNode.isEmpty()) {
            DoubleLinkedPoiCategory parent = this.createOrGetPoiCategory(((Category)currentXMLNode.getFirst()).getTitle());
            this.titleMap.put(parent.getTitle(), parent);
            if (currentXMLNode.getFirst() == xmlRootCategory) {
                this.root = parent;
            }
            for (Category c : ((Category)currentXMLNode.pop()).getCategory()) {
                DoubleLinkedPoiCategory child = this.createOrGetPoiCategory(c.getTitle());
                child.setParent((PoiCategory)parent);
                currentXMLNode.add(c);
            }
        }
        DoubleLinkedPoiCategory.calculateCategoryIDs((DoubleLinkedPoiCategory)this.root, (int)0);
    }

    private DoubleLinkedPoiCategory createOrGetPoiCategory(String title) {
        DoubleLinkedPoiCategory ret = this.titleMap.get(title);
        if (ret == null) {
            ret = new DoubleLinkedPoiCategory(title, null);
            LOGGER.finer("Added category: " + ret);
            this.titleMap.put(title, ret);
        }
        return ret;
    }

    public PoiCategory getPoiCategoryByID(int id) {
        String key;
        PoiCategory ret = null;
        Iterator<String> iterator = this.titleMap.keySet().iterator();
        while (iterator.hasNext() && (ret = (PoiCategory)this.titleMap.get(key = iterator.next())).getID() != id) {
        }
        return ret;
    }

    public PoiCategory getPoiCategoryByTitle(String title) {
        return (PoiCategory)this.titleMap.get(title);
    }

    public PoiCategory getRootCategory() {
        return this.root;
    }
}

