/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.poi.writer.osmosis.PoiWriterTask;

public class PoiWriterConfiguration {
    private boolean allTags;
    private BoundingBox bboxConfiguration;
    private String comment;
    private int fileSpecificationVersion;
    private boolean filterCategories;
    private File outputFile;
    private String preferredLanguage;
    private URL tagMapping;
    private boolean ways;
    private String writerVersion;

    public void addBboxConfiguration(String bbox) {
        if (bbox != null) {
            this.setBboxConfiguration(BoundingBox.fromString((String)bbox));
        }
    }

    public void addOutputFile(String file) {
        if (file != null) {
            File f = new File(file);
            if (f.isDirectory()) {
                throw new IllegalArgumentException("output file parameter points to a directory, must be a file");
            }
            if (f.exists() && !f.canWrite()) {
                throw new IllegalArgumentException("output file parameter points to a file we have no write permissions");
            }
            this.setOutputFile(f);
        }
    }

    public BoundingBox getBboxConfiguration() {
        return this.bboxConfiguration;
    }

    public String getComment() {
        return this.comment;
    }

    public int getFileSpecificationVersion() {
        return this.fileSpecificationVersion;
    }

    public boolean isFilterCategories() {
        return this.filterCategories;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public URL getTagMapping() {
        return this.tagMapping;
    }

    public String getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isAllTags() {
        return this.allTags;
    }

    public boolean isWays() {
        return this.ways;
    }

    public void loadTagMappingFile(String file) {
        if (file != null) {
            File f = new File(file);
            if (!f.exists()) {
                throw new IllegalArgumentException("tag mapping file parameter points to a file that does not exist");
            }
            if (f.isDirectory()) {
                throw new IllegalArgumentException("tag mapping file parameter points to a directory, must be a file");
            }
            if (!f.canRead()) {
                throw new IllegalArgumentException("tag mapping file parameter points to a file we have no read permissions");
            }
            try {
                this.tagMapping = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.tagMapping = PoiWriterTask.class.getClassLoader().getResource("poi-mapping.xml");
        }
    }

    public void setAllTags(boolean allTags) {
        this.allTags = allTags;
    }

    public void setBboxConfiguration(BoundingBox bboxConfiguration) {
        this.bboxConfiguration = bboxConfiguration;
    }

    public void setComment(String comment) {
        if (comment != null && !comment.isEmpty()) {
            this.comment = comment;
        }
    }

    public void setFileSpecificationVersion(int fileSpecificationVersion) {
        this.fileSpecificationVersion = fileSpecificationVersion;
    }

    public void setFilterCategories(boolean filterCategories) {
        this.filterCategories = filterCategories;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        if (preferredLanguage != null && !preferredLanguage.isEmpty()) {
            this.preferredLanguage = preferredLanguage;
        }
    }

    public void setWays(boolean ways) {
        this.ways = ways;
    }

    public void setWriterVersion(String writerVersion) {
        this.writerVersion = writerVersion;
    }
}

