/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.writer;

import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.poi.writer.PoiWriter;
import org.mapsforge.poi.writer.logging.LoggerWrapper;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;

class GeoTagger {
    private static final Logger LOGGER = LoggerWrapper.getLogger(GeoTagger.class.getName());
    private PoiWriter writer;
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private PreparedStatement pStmtInsertWayNodes = null;
    private PreparedStatement pStmtDeletePoiData = null;
    private PreparedStatement pStmtDeletePoiCategory = null;
    private PreparedStatement pStmtDeletePoiIndex = null;
    private PreparedStatement pStmtUpdateData = null;
    private PreparedStatement pStmtNodesInBox = null;
    private PreparedStatement pStmtTagsByID = null;
    private List<List<Relation>> administrativeBoundaries;
    private List<Relation> postalBoundaries;
    private int batchCountWays = 0;
    private int batchCountRelation = 0;

    GeoTagger(PoiWriter writer) {
        this.writer = writer;
        try {
            this.pStmtInsertWayNodes = writer.conn.prepareStatement("INSERT INTO waynodes VALUES (?, ?, ?);");
            this.pStmtDeletePoiData = writer.conn.prepareStatement("DELETE FROM poi_data WHERE id = ?;");
            this.pStmtDeletePoiIndex = writer.conn.prepareStatement("DELETE FROM poi_index WHERE id = ?;");
            this.pStmtDeletePoiCategory = writer.conn.prepareStatement("DELETE FROM poi_category_map WHERE id = ?;");
            this.pStmtUpdateData = writer.conn.prepareStatement("UPDATE poi_data SET data = ? WHERE id = ?;");
            this.pStmtNodesInBox = writer.conn.prepareStatement("SELECT poi_index.id, poi_index.minLat, poi_index.minLon FROM poi_index WHERE poi_index.minLat <= ? AND poi_index.minLon <= ? AND poi_index.minLat >= ? AND poi_index.minLon >= ?");
            this.pStmtTagsByID = writer.conn.prepareStatement("SELECT poi_data.id, poi_data.data FROM poi_data WHERE poi_data.id = ?;");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.postalBoundaries = new ArrayList<Relation>();
        this.administrativeBoundaries = new ArrayList<List<Relation>>();
        for (int i = 0; i < 12; ++i) {
            this.administrativeBoundaries.add(new ArrayList());
        }
    }

    void storeAdministrativeBoundaries(Way way) {
        Collection tags = way.getTags();
        for (Tag tag : tags) {
            switch (tag.getKey()) {
                case "building": 
                case "highway": 
                case "landuse": 
                case "leisure": 
                case "amenity": 
                case "sport": 
                case "waterway": 
                case "barrier": 
                case "railway": 
                case "foot": {
                    return;
                }
                case "boundary": {
                    this.storeWay(way);
                    return;
                }
            }
        }
        this.storeWay(way);
    }

    private void storeWay(Way way) {
        int i = 0;
        try {
            for (WayNode wayNode : way.getWayNodes()) {
                this.pStmtInsertWayNodes.setLong(1, way.getId());
                this.pStmtInsertWayNodes.setLong(2, wayNode.getNodeId());
                this.pStmtInsertWayNodes.setInt(3, i);
                this.pStmtInsertWayNodes.addBatch();
                ++i;
                ++this.batchCountWays;
                if (this.batchCountWays % 1024 != 0) continue;
                this.pStmtInsertWayNodes.executeBatch();
                this.pStmtInsertWayNodes.clearBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    void filterBoundaries(Relation relation) {
        if ("boundary".equalsIgnoreCase(this.writer.getTagValue(relation.getTags(), "type"))) {
            String boundaryCategory = this.writer.getTagValue(relation.getTags(), "boundary");
            if ("administrative".equalsIgnoreCase(boundaryCategory)) {
                String adminLevelValue = this.writer.getTagValue(relation.getTags(), "admin_level");
                if (adminLevelValue == null) {
                    return;
                }
                switch (adminLevelValue.trim()) {
                    case "7": {
                        this.administrativeBoundaries.get(6).add(relation);
                        return;
                    }
                    case "8": {
                        this.administrativeBoundaries.get(7).add(relation);
                        return;
                    }
                    case "9": {
                        this.administrativeBoundaries.get(8).add(relation);
                        return;
                    }
                    case "10": {
                        this.administrativeBoundaries.get(9).add(relation);
                        return;
                    }
                }
            } else if ("postal_code".equalsIgnoreCase(boundaryCategory)) {
                this.postalBoundaries.add(relation);
            }
        }
    }

    void processBoundaries() {
        int nPostalBounds = 0;
        for (Relation postalBoundary : this.postalBoundaries) {
            if (nPostalBounds % 10 == 0) {
                System.out.printf("Progress: PostalBounds " + nPostalBounds + "/" + this.postalBoundaries.size() + " \r", new Object[0]);
            }
            this.processBoundary(postalBoundary, true);
            ++nPostalBounds;
        }
        this.commit();
        for (int i = this.administrativeBoundaries.size() - 1; i >= 0; --i) {
            int nAdminBounds = 0;
            List<Relation> administrativeBoundary = this.administrativeBoundaries.get(i);
            for (Relation relation : administrativeBoundary) {
                if (nAdminBounds % 10 == 0) {
                    System.out.printf("Progress: AdminLevel " + i + ": " + nAdminBounds + "/" + administrativeBoundary.size() + " \r", new Object[0]);
                }
                this.processBoundary(relation, false);
                ++nAdminBounds;
            }
            this.commit();
        }
    }

    private void processBoundary(Relation relation, boolean isPostCode) {
        Coordinate[] coordinates = this.mergeBoundary(relation);
        if (coordinates == null) {
            return;
        }
        LOGGER.finer("Polygon created; ");
        Polygon polygon = GEOMETRY_FACTORY.createPolygon(GEOMETRY_FACTORY.createLinearRing(coordinates), null);
        Map<Poi, Map<String, String>> pois = this.getPoisInsidePolygon(polygon);
        if (isPostCode) {
            pois = this.removeDoublePois(pois);
            String postcode = this.writer.getTagValue(relation.getTags(), "postal_code");
            if (postcode != null && !postcode.isEmpty()) {
                int i;
                this.updateTagData(pois, "addr:postcode", postcode);
                String city = this.writer.getTagValue(relation.getTags(), "note");
                if (city != null && !city.isEmpty() && (i = city.indexOf(postcode)) >= 0) {
                    city = city.substring(0, i) + city.substring(postcode.length(), city.length()).trim();
                    this.updateTagData(pois, "addr:city", city);
                }
            }
        } else {
            AbstractMap.SimpleEntry<Poi, Map<String, String>> adminArea = null;
            block11: for (Map.Entry<Poi, Map<String, String>> entry : pois.entrySet()) {
                Map<String, String> tagmap = entry.getValue();
                if (!tagmap.keySet().contains("place") || !tagmap.keySet().contains("is_in")) continue;
                switch (tagmap.get("place")) {
                    case "town": 
                    case "village": 
                    case "hamlet": 
                    case "isolated_dwelling": 
                    case "allotments": 
                    case "suburb": {
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                if (adminArea == null) {
                    adminArea = new AbstractMap.SimpleEntry<Poi, Map<String, String>>(entry.getKey(), entry.getValue());
                    continue;
                }
                Point center = polygon.getCentroid();
                LatLong centroid = new LatLong(center.getY(), center.getX());
                double disOld = centroid.sphericalDistance(new LatLong(((Poi)adminArea.getKey()).lat, ((Poi)adminArea.getKey()).lon));
                double disNew = centroid.sphericalDistance(new LatLong(entry.getKey().lat, entry.getKey().lon));
                if (!(disNew < disOld)) continue;
                adminArea = new AbstractMap.SimpleEntry<Poi, Map<String, String>>(entry.getKey(), entry.getValue());
            }
            String isInTagName = null;
            if (adminArea != null) {
                isInTagName = (String)((Map)adminArea.getValue()).get("is_in");
            }
            String relationName = this.writer.getTagValue(relation.getTags(), "name");
            String value = relationName + (isInTagName != null ? "," + isInTagName : "");
            this.updateTagData(pois, "is_in", value);
            LOGGER.fine(relationName + ": #Pois found: " + pois.size() + "; Is_in tags set");
        }
    }

    private Map<Poi, Map<String, String>> removeDoublePois(Map<Poi, Map<String, String>> pois) {
        HashMap<String, Poi> uniqueHighways = new HashMap<String, Poi>();
        Iterator<Map.Entry<Poi, Map<String, String>>> it = pois.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Poi, Map<String, String>> entry = it.next();
            Map<String, String> tags = entry.getValue();
            if (!tags.containsKey("name") || !tags.containsKey("highway")) continue;
            String name = tags.get("name");
            if (uniqueHighways.containsKey(name)) {
                try {
                    long id = entry.getKey().id;
                    this.pStmtDeletePoiData.setLong(1, id);
                    this.pStmtDeletePoiIndex.setLong(1, id);
                    this.pStmtDeletePoiCategory.setLong(1, id);
                    this.pStmtDeletePoiData.addBatch();
                    this.pStmtDeletePoiIndex.addBatch();
                    this.pStmtDeletePoiCategory.addBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                it.remove();
                continue;
            }
            uniqueHighways.put(name, entry.getKey());
        }
        try {
            this.pStmtDeletePoiCategory.executeBatch();
            this.pStmtDeletePoiCategory.clearBatch();
            this.pStmtDeletePoiData.executeBatch();
            this.pStmtDeletePoiData.clearBatch();
            this.pStmtDeletePoiIndex.executeBatch();
            this.pStmtDeletePoiIndex.clearBatch();
            this.writer.conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pois;
    }

    private void updateTagData(Map<Poi, Map<String, String>> pois, String key, String value) {
        for (Map.Entry<Poi, Map<String, String>> entry : pois.entrySet()) {
            Poi poi = entry.getKey();
            String tmpValue = value;
            Map<String, String> tagmap = entry.getValue();
            if (!tagmap.keySet().contains("name")) continue;
            if (tagmap.keySet().contains(key)) {
                String prev;
                if (!key.equals("is_in") || (prev = tagmap.get(key)).contains(",") || prev.contains(";")) continue;
                if (tmpValue.contains(",") || tmpValue.contains(";")) {
                    tmpValue = prev + "," + tmpValue;
                }
            }
            tagmap.put(key, tmpValue);
            try {
                this.pStmtUpdateData.setLong(2, poi.id);
                this.pStmtUpdateData.setString(1, this.writer.tagsToString(tagmap));
                this.pStmtUpdateData.addBatch();
                ++this.batchCountRelation;
                if (this.batchCountRelation % 1024 != 0) continue;
                this.pStmtUpdateData.executeBatch();
                this.pStmtUpdateData.clearBatch();
                this.writer.conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private Coordinate[] mergeBoundary(Relation relation) {
        ArrayList<List> bounds = new ArrayList<List>();
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMemberType().equals((Object)EntityType.Way) && "outer".equalsIgnoreCase(relationMember.getMemberRole())) {
                List<Long> waynodes = this.writer.findWayNodesByWayID(relationMember.getMemberId());
                if (waynodes != null && !waynodes.isEmpty()) {
                    bounds.add(waynodes);
                    continue;
                }
                LOGGER.finer("\n---> Member not found | Membertype= " + relationMember.getMemberType().name() + ", Memberrole= " + relationMember.getMemberRole() + "\n");
                continue;
            }
            LOGGER.finer("\n---> Member not accepted | Membertype= " + relationMember.getMemberType().name() + ", Memberrole= " + relationMember.getMemberRole() + "\n");
        }
        if (bounds.isEmpty()) {
            return null;
        }
        LOGGER.fine("Administrative: " + this.writer.getTagValue(relation.getTags(), "name") + " #Members: " + relation.getMembers().size() + " #Segments: " + bounds.size());
        double threshold = 20.0;
        for (int i = 1; i < bounds.size(); ++i) {
            List I;
            List check = I = (List)bounds.get(i);
            long nIa = (Long)I.get(0);
            long nIb = (Long)I.get(I.size() - 1);
            LatLong Ia = this.writer.findNodeByID((Long)I.get(0));
            LatLong Ib = this.writer.findNodeByID((Long)I.get(I.size() - 1));
            for (int j = 0; j < bounds.size(); ++j) {
                if (i == j) continue;
                List J = (List)bounds.get(j);
                long nJa = (Long)J.get(0);
                long nJb = (Long)J.get(J.size() - 1);
                LatLong Ja = this.writer.findNodeByID((Long)J.get(0));
                LatLong Jb = this.writer.findNodeByID((Long)J.get(J.size() - 1));
                if (Ia == null || Ib == null || Ja == null || Jb == null) {
                    return null;
                }
                if (Ia.sphericalDistance(Jb) < 20.0) {
                    I.remove(0);
                    J.addAll(I);
                    bounds.set(j, J);
                    bounds.remove(i);
                    --i;
                    LOGGER.finest("matches: " + Ia.latitude + ", " + Ia.longitude + "; Ids: " + nIa + ", " + nJb);
                    break;
                }
                if (Ib.sphericalDistance(Jb) < 20.0) {
                    I = Lists.reverse((List)I);
                    I.remove(0);
                    J.addAll(I);
                    bounds.set(j, J);
                    bounds.remove(i);
                    --i;
                    LOGGER.finest("reverse I matches: " + Ib.latitude + ", " + Ib.longitude + "; Ids: " + nIb + ", " + nJb);
                    break;
                }
                if (Ia.sphericalDistance(Ja) < 20.0) {
                    J = Lists.reverse((List)J);
                    I.remove(0);
                    J.addAll(I);
                    bounds.set(j, J);
                    bounds.remove(i);
                    --i;
                    LOGGER.finest("reverse J matches: " + Ia.latitude + ", " + Ia.longitude + "; Ids: " + nIa + ", " + nJb);
                    break;
                }
                if (!(Ib.sphericalDistance(Ja) < 20.0)) continue;
                J = Lists.reverse((List)J);
                I = Lists.reverse((List)I);
                I.remove(0);
                J.addAll(I);
                bounds.set(j, J);
                bounds.remove(i);
                --i;
                LOGGER.finest("reverse Both matches: " + Ib.latitude + ", " + Ib.longitude + "; Ids: " + nIb + ", " + nJa);
                break;
            }
            if (!bounds.contains(check) || bounds.size() <= 1) continue;
            LOGGER.finer("Merging failed");
            return null;
        }
        LOGGER.finer("Bound merging finished; Size= " + bounds.size());
        if (bounds.size() != 1) {
            return null;
        }
        LOGGER.finer("Bound has right size; ");
        Long[] area = ((List)bounds.get(0)).toArray(new Long[((List)bounds.get(0)).size()]);
        LatLong node = this.writer.findNodeByID(area[0]);
        if (node == null || node.sphericalDistance(this.writer.findNodeByID(area[area.length - 1])) >= 20.0) {
            return null;
        }
        area[0] = area[area.length - 1];
        LOGGER.finer("Last node is first node; ");
        Coordinate[] coordinates = new Coordinate[area.length];
        for (int j = 0; j < area.length; ++j) {
            LatLong wayNode = this.writer.findNodeByID(area[j]);
            if (wayNode == null) {
                return null;
            }
            coordinates[j] = new Coordinate(wayNode.longitude, wayNode.latitude);
        }
        return coordinates;
    }

    private Map<Poi, Map<String, String>> getPoisInsidePolygon(Polygon polygon) {
        Coordinate[] coordinates = polygon.getBoundary().getCoordinates();
        double minLat = coordinates[0].y;
        double minLon = coordinates[0].x;
        BoundingBox bbox = new BoundingBox(minLat, minLon, minLat, minLon);
        for (Coordinate coord : coordinates) {
            bbox = bbox.extendCoordinates(coord.y, coord.x);
        }
        HashMap<Poi, Map<String, String>> pois = new HashMap<Poi, Map<String, String>>();
        LOGGER.finer("Bbox: minLat: " + bbox.minLatitude + "; minLon: " + bbox.minLongitude + "; maxLat: " + bbox.maxLatitude + "; maxLon: " + bbox.maxLongitude + ";");
        try {
            this.pStmtNodesInBox.setDouble(1, bbox.maxLatitude);
            this.pStmtNodesInBox.setDouble(2, bbox.maxLongitude);
            this.pStmtNodesInBox.setDouble(3, bbox.minLatitude);
            this.pStmtNodesInBox.setDouble(4, bbox.minLongitude);
            ResultSet rs = this.pStmtNodesInBox.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                double lat = rs.getDouble(2);
                double lon = rs.getDouble(3);
                Point point = GEOMETRY_FACTORY.createPoint(new Coordinate(lon, lat));
                if (!point.within((Geometry)polygon)) continue;
                this.pStmtTagsByID.setLong(1, id);
                ResultSet rsTags = this.pStmtTagsByID.executeQuery();
                HashMap<String, String> tagmap = new HashMap<String, String>();
                while (rsTags.next()) {
                    tagmap.putAll(this.writer.stringToTags(rsTags.getString(2)));
                }
                rsTags.close();
                pois.put(new Poi(id, lat, lon), tagmap);
                LOGGER.finest("Bbox: InnerNode-Id: " + id + "; Lat: " + lat + "; Lon: " + lon + ";");
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pois;
    }

    void commit() {
        try {
            this.pStmtInsertWayNodes.executeBatch();
            this.pStmtUpdateData.executeBatch();
            this.pStmtInsertWayNodes.clearBatch();
            this.pStmtUpdateData.clearBatch();
            this.writer.conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private class Poi {
        long id;
        double lat;
        double lon;

        Poi(long id, double lat, double lon) {
            this.id = id;
            this.lat = lat;
            this.lon = lon;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Poi && ((Poi)obj).id == this.id;
        }

        public int hashCode() {
            return Long.valueOf(this.id).hashCode();
        }
    }
}

