/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Tag;
import org.mapsforge.poi.storage.PoiCategory;

public class PointOfInterest {
    private final long id;
    private final double latitude;
    private final double longitude;
    private final Set<Tag> tags;
    private final Set<PoiCategory> categories;

    public PointOfInterest(long id, double latitude, double longitude, String name, PoiCategory category) {
        this(id, latitude, longitude, Collections.singleton(new Tag("name", name)), Collections.singleton(category));
    }

    public PointOfInterest(long id, double latitude, double longitude, Set<Tag> tags, Set<PoiCategory> categories) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.tags = tags == null ? Collections.emptySet() : tags;
        this.categories = categories == null ? Collections.emptySet() : categories;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointOfInterest)) {
            return false;
        }
        PointOfInterest other = (PointOfInterest)obj;
        return this.id == other.id;
    }

    public Set<PoiCategory> getCategories() {
        return this.categories;
    }

    public PoiCategory getCategory() {
        if (this.categories.size() > 1) {
            return this.categories.toArray(new PoiCategory[this.categories.size()])[0];
        }
        if (this.categories.size() == 1) {
            return this.categories.toArray(new PoiCategory[this.categories.size()])[0];
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public LatLong getLatLong() {
        return new LatLong(this.latitude, this.longitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getName() {
        return this.getName(Locale.getDefault().getLanguage());
    }

    public String getName(String language) {
        if (language != null && language.trim().length() > 0) {
            String nameStr = "name:" + language.toLowerCase(Locale.ENGLISH);
            for (Tag tag : this.tags) {
                if (!nameStr.equalsIgnoreCase(tag.key)) continue;
                return tag.value;
            }
            String baseLanguage = language.split("[-_]")[0];
            nameStr = "name:" + baseLanguage.toLowerCase(Locale.ENGLISH);
            for (Tag tag : this.tags) {
                if (!nameStr.equalsIgnoreCase(tag.key)) continue;
                return tag.value;
            }
        }
        for (Tag tag : this.tags) {
            if (!"name".equalsIgnoreCase(tag.key)) continue;
            return tag.value;
        }
        return null;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("POI: (").append(this.latitude).append(',').append(this.longitude).append(") ").append(this.tags.toString());
        for (PoiCategory category : this.categories) {
            sb.append(' ').append(category.getID());
        }
        return sb.toString();
    }
}

