/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.poi.storage.PoiCategoryFilter;
import org.mapsforge.poi.storage.PoiCategoryManager;
import org.mapsforge.poi.storage.PoiCategoryRangeQueryGenerator;
import org.mapsforge.poi.storage.PoiFileInfo;
import org.mapsforge.poi.storage.PoiPersistenceManager;
import org.mapsforge.poi.storage.PointOfInterest;

public abstract class AbstractPoiPersistenceManager
implements PoiPersistenceManager {
    protected PoiCategoryManager categoryManager = null;
    protected String poiFile;
    protected PoiFileInfo poiFileInfo;
    protected final List<PointOfInterest> ret = new ArrayList<PointOfInterest>();
    protected PointOfInterest poi = null;

    protected AbstractPoiPersistenceManager() {
    }

    @Override
    public Collection<PointOfInterest> findNearPosition(LatLong point, int distance, PoiCategoryFilter filter, List<Tag> patterns, int limit) {
        double minLat = point.latitude - LatLongUtils.latitudeDistance((int)distance);
        double minLon = point.longitude - LatLongUtils.longitudeDistance((int)distance, (double)point.latitude);
        double maxLat = point.latitude + LatLongUtils.latitudeDistance((int)distance);
        double maxLon = point.longitude + LatLongUtils.longitudeDistance((int)distance, (double)point.latitude);
        return this.findInRect(new BoundingBox(minLat, minLon, maxLat, maxLon), filter, patterns, limit);
    }

    @Override
    public PoiCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    @Override
    public String getPoiFile() {
        return this.poiFile;
    }

    @Override
    public PoiFileInfo getPoiFileInfo() {
        if (this.poiFileInfo == null) {
            this.readPoiFileInfo();
        }
        return this.poiFileInfo;
    }

    protected static String getSQLSelectString(PoiCategoryFilter filter, int count, int version) {
        if (filter != null) {
            return PoiCategoryRangeQueryGenerator.getSQLSelectString(filter, count, version);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT poi_index.id, poi_index.minLat, poi_index.minLon FROM poi_index ");
        if (count > 0) {
            sb.append("JOIN poi_data ON poi_index.id = poi_data.id ");
        }
        sb.append("WHERE poi_index.minLat <= ? AND poi_index.minLon <= ? AND poi_index.minLat >= ? AND poi_index.minLon >= ?");
        for (int i = 0; i < count; ++i) {
            sb.append(" AND poi_data.data LIKE ?");
        }
        return sb.append(" LIMIT ?;").toString();
    }

    @Override
    public void setCategoryManager(PoiCategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    protected static Set<Tag> stringToTags(String data) {
        String[] split;
        HashSet<Tag> tags = new HashSet<Tag>();
        for (String s : split = data.split("\r")) {
            String[] keyValue;
            if (s.indexOf(61) <= -1 || (keyValue = s.split(String.valueOf('='))).length != 2) continue;
            tags.add(new Tag(keyValue[0], keyValue[1]));
        }
        return tags;
    }

    protected static String tagsToString(Set<Tag> tags) {
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags) {
            if (sb.length() > 0) {
                sb.append('\r');
            }
            sb.append(tag.key).append('=').append(tag.value);
        }
        return sb.toString();
    }
}

