/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.Map;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryManager;
import org.mapsforge.poi.storage.UnknownPoiCategoryException;

public abstract class AbstractPoiCategoryManager
implements PoiCategoryManager {
    protected static final String SELECT_STATEMENT = "SELECT * FROM poi_categories ORDER BY id ASC;";
    protected PoiCategory rootCategory = null;
    protected Map<Integer, PoiCategory> categoryMap = null;

    @Override
    public PoiCategory getPoiCategoryByID(int id) throws UnknownPoiCategoryException {
        if (this.categoryMap.get(id) == null) {
            throw new UnknownPoiCategoryException();
        }
        return this.categoryMap.get(id);
    }

    @Override
    public PoiCategory getPoiCategoryByTitle(String title) throws UnknownPoiCategoryException {
        for (int key : this.categoryMap.keySet()) {
            if (!this.categoryMap.get(key).getTitle().equalsIgnoreCase(title)) continue;
            return this.categoryMap.get(key);
        }
        throw new UnknownPoiCategoryException();
    }

    @Override
    public PoiCategory getRootCategory() throws UnknownPoiCategoryException {
        if (this.rootCategory == null) {
            throw new UnknownPoiCategoryException();
        }
        return this.rootCategory;
    }
}

