/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import org.mapsforge.poi.storage.PoiCategory;

public class DoubleLinkedPoiCategory
implements PoiCategory {
    private final String title;
    private PoiCategory parent;
    private final Vector<PoiCategory> childCategories;
    private int id;

    public DoubleLinkedPoiCategory(String title, PoiCategory parent) {
        this(title, parent, -1);
    }

    public DoubleLinkedPoiCategory(String title, PoiCategory parent, int id) {
        this.title = title;
        this.parent = parent;
        this.id = id;
        this.childCategories = new Vector();
        if (parent != null) {
            ((DoubleLinkedPoiCategory)parent).addChildNode(this);
        }
    }

    private void addChildNode(DoubleLinkedPoiCategory categoryNode) {
        this.childCategories.add(categoryNode);
    }

    public static int calculateCategoryIDs(DoubleLinkedPoiCategory rootNode, int maxValue) {
        int newMax = maxValue;
        for (PoiCategory c : rootNode.childCategories) {
            newMax = DoubleLinkedPoiCategory.calculateCategoryIDs((DoubleLinkedPoiCategory)c, newMax);
        }
        rootNode.id = newMax;
        return newMax + 1;
    }

    @Override
    public Collection<PoiCategory> deepChildren() {
        HashSet<PoiCategory> ret = new HashSet<PoiCategory>();
        Stack<PoiCategory> stack = new Stack<PoiCategory>();
        stack.push(this);
        while (!stack.isEmpty()) {
            for (PoiCategory c : ((PoiCategory)stack.pop()).getChildren()) {
                ret.add(c);
                stack.push(c);
            }
        }
        return ret;
    }

    @Override
    public Collection<PoiCategory> getChildren() {
        return this.childCategories;
    }

    public static String getGraphVizString(DoubleLinkedPoiCategory rootNode) {
        StringBuilder sb = new StringBuilder();
        Stack<PoiCategory> stack = new Stack<PoiCategory>();
        stack.push(rootNode);
        sb.append("// dot test.dot -Tpng > test.png\r\n");
        sb.append("digraph Categories {\r\n");
        sb.append("  graph [\r\nrankdir = \"LR\"\r\n]\r\n\r\nnode [\r\nshape = \"plaintext\"\r\n]");
        while (!stack.isEmpty()) {
            DoubleLinkedPoiCategory currentNode = (DoubleLinkedPoiCategory)stack.pop();
            for (PoiCategory childNode : currentNode.childCategories) {
                stack.push(childNode);
                sb.append("\t\"").append(currentNode.getTitle()).append(" (").append(currentNode.getID()).append(")").append("\" -> \"").append(childNode.getTitle()).append(" (").append(childNode.getID()).append(")").append("\"\r\n");
            }
        }
        sb.append("}\r\n");
        return sb.toString();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public PoiCategory getParent() {
        return this.parent;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setParent(PoiCategory parent) {
        this.parent = parent;
        ((DoubleLinkedPoiCategory)parent).addChildNode(this);
    }

    public String toString() {
        return "DoubleLinked POICategory: ('" + this.title + "'," + this.id + ") @ " + Integer.toHexString(this.hashCode());
    }
}

