/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.Collection;
import java.util.Iterator;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryFilter;

public final class PoiCategoryRangeQueryGenerator {
    private PoiCategoryRangeQueryGenerator() {
    }

    public static String getSQLSelectString(PoiCategoryFilter filter, int count, LatLong orderBy, int version) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT poi_index.id, poi_index.minLat, poi_index.minLon FROM poi_index ");
        if (version < 2) {
            sb.append("JOIN poi_data ON poi_index.id = poi_data.id ");
        } else {
            sb.append("JOIN poi_category_map ON poi_index.id = poi_category_map.id ");
            if (count > 0) {
                sb.append("JOIN poi_data ON poi_index.id = poi_data.id ");
            }
        }
        sb.append("WHERE poi_index.minLat <= ? AND poi_index.minLon <= ? AND poi_index.minLat >= ? AND poi_index.minLon >= ?");
        sb.append(PoiCategoryRangeQueryGenerator.getSQLWhereClauseString(filter, version));
        for (int i = 0; i < count; ++i) {
            sb.append(" AND poi_data.data LIKE ?");
        }
        if (orderBy != null) {
            sb.append(" ORDER BY ((").append(orderBy.latitude).append(" - poi_index.minLat) * (").append(orderBy.latitude).append(" - poi_index.minLat))").append(" + ((").append(orderBy.longitude).append(" - poi_index.minLon) * (").append(orderBy.longitude).append(" - poi_index.minLon)) ASC");
        }
        return sb.append(" LIMIT ?;").toString();
    }

    private static String getSQLWhereClauseString(PoiCategoryFilter filter, int version) {
        Collection<PoiCategory> superCategories = filter.getAcceptedSuperCategories();
        if (superCategories.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND (");
        Iterator<PoiCategory> superCatIter = superCategories.iterator();
        while (superCatIter.hasNext()) {
            PoiCategory superCat = superCatIter.next();
            Collection<PoiCategory> categories = superCat.deepChildren();
            categories.add(superCat);
            if (version < 2) {
                sb.append("poi_data.category IN (");
            } else {
                sb.append("poi_category_map.category IN (");
            }
            Iterator<PoiCategory> catIter = categories.iterator();
            while (catIter.hasNext()) {
                PoiCategory cat = catIter.next();
                sb.append(cat.getID());
                if (!catIter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (!superCatIter.hasNext()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }
}

