/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryFilter;

public class WhitelistPoiCategoryFilter
implements PoiCategoryFilter {
    private final List<PoiCategory> whiteList = new ArrayList<PoiCategory>();

    @Override
    public void addCategory(PoiCategory category) {
        this.whiteList.add(category);
    }

    @Override
    public Collection<PoiCategory> getAcceptedCategories() {
        HashSet<PoiCategory> ret = new HashSet<PoiCategory>();
        Stack<PoiCategory> stack = new Stack<PoiCategory>();
        for (PoiCategory wlCategory : this.whiteList) {
            stack.push(wlCategory);
        }
        while (!stack.isEmpty()) {
            PoiCategory c = (PoiCategory)stack.pop();
            ret.add(c);
            for (PoiCategory child : c.getChildren()) {
                stack.push(child);
            }
        }
        return ret;
    }

    @Override
    public Collection<PoiCategory> getAcceptedSuperCategories() {
        HashSet<PoiCategory> ret = new HashSet<PoiCategory>();
        Collection<PoiCategory> acceptedCategories = this.getAcceptedCategories();
        for (PoiCategory c : this.whiteList) {
            if (c.getParent() != null && acceptedCategories.contains(c.getParent())) continue;
            ret.add(c);
        }
        return ret;
    }

    @Override
    public boolean isAcceptedCategory(PoiCategory category) {
        if (this.whiteList.contains(category)) {
            return true;
        }
        if (category.getParent() != null) {
            return this.isAcceptedCategory(category.getParent());
        }
        return false;
    }
}

