/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.Collection;
import java.util.Iterator;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryFilter;

public final class PoiCategoryRangeQueryGenerator {
    private PoiCategoryRangeQueryGenerator() {
    }

    public static String getSQLSelectString(PoiCategoryFilter filter, int count, LatLong orderBy) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT poi_index.id, poi_index.lat, poi_index.lon, poi_data.data FROM poi_index ");
        sb.append("JOIN poi_category_map ON poi_index.id = poi_category_map.id ");
        sb.append("JOIN poi_data ON poi_index.id = poi_data.id ");
        sb.append("WHERE poi_index.lat <= ? AND poi_index.lon <= ? AND poi_index.lat >= ? AND poi_index.lon >= ?");
        sb.append(PoiCategoryRangeQueryGenerator.getSQLWhereClauseString(filter));
        for (int i = 0; i < count; ++i) {
            sb.append(i == 0 ? " AND (" : " OR ");
            sb.append("poi_data.data LIKE ?");
            if (i != count - 1) continue;
            sb.append(")");
        }
        if (orderBy != null) {
            sb.append(" ORDER BY ((").append(orderBy.latitude).append(" - poi_index.lat) * (").append(orderBy.latitude).append(" - poi_index.lat))").append(" + ((").append(orderBy.longitude).append(" - poi_index.lon) * (").append(orderBy.longitude).append(" - poi_index.lon)) ASC");
        }
        return sb.append(" LIMIT ?;").toString();
    }

    private static String getSQLWhereClauseString(PoiCategoryFilter filter) {
        Collection<PoiCategory> superCategories = filter.getAcceptedSuperCategories();
        if (superCategories.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND (");
        Iterator<PoiCategory> superCatIter = superCategories.iterator();
        while (superCatIter.hasNext()) {
            PoiCategory superCat = superCatIter.next();
            Collection<PoiCategory> categories = superCat.deepChildren();
            categories.add(superCat);
            sb.append("poi_category_map.category IN (");
            Iterator<PoiCategory> catIter = categories.iterator();
            while (catIter.hasNext()) {
                PoiCategory cat = catIter.next();
                sb.append(cat.getID());
                if (!catIter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (!superCatIter.hasNext()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }
}

