/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.poi.storage.PoiCategoryFilter;
import org.mapsforge.poi.storage.PoiCategoryManager;
import org.mapsforge.poi.storage.PoiCategoryRangeQueryGenerator;
import org.mapsforge.poi.storage.PoiPersistenceManager;
import org.mapsforge.poi.storage.PointOfInterest;

public abstract class AbstractPoiPersistenceManager
implements PoiPersistenceManager {
    protected PoiCategoryManager categoryManager = null;
    protected String poiFile;
    protected final List<PointOfInterest> ret = new ArrayList<PointOfInterest>();
    protected PointOfInterest poi = null;

    protected AbstractPoiPersistenceManager() {
    }

    @Override
    public Collection<PointOfInterest> findNearPosition(LatLong point, int distance, PoiCategoryFilter filter, String pattern, int limit) {
        double minLat = point.latitude - LatLongUtils.latitudeDistance((int)distance);
        double minLon = point.longitude - LatLongUtils.longitudeDistance((int)distance, (double)point.latitude);
        double maxLat = point.latitude + LatLongUtils.latitudeDistance((int)distance);
        double maxLon = point.longitude + LatLongUtils.longitudeDistance((int)distance, (double)point.latitude);
        return this.findInRect(new BoundingBox(minLat, minLon, maxLat, maxLon), filter, pattern, limit);
    }

    @Override
    public PoiCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    @Override
    public String getPoiFile() {
        return this.poiFile;
    }

    protected static String getSQLSelectString(PoiCategoryFilter filter, String pattern) {
        if (filter != null) {
            return PoiCategoryRangeQueryGenerator.getSQLSelectString(filter, pattern);
        }
        return "SELECT poi_index.id, poi_index.minLat, poi_index.minLon, poi_data.data, poi_data.category FROM poi_index JOIN poi_data ON poi_index.id = poi_data.id WHERE minLat <= ? AND minLon <= ? AND minLat >= ? AND minLon >= ?" + (pattern != null ? " AND poi_data.data LIKE ?" : "") + " LIMIT ?;";
    }

    @Override
    public void setCategoryManager(PoiCategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }
}

