/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.Collection;
import java.util.Iterator;
import org.mapsforge.poi.storage.PoiCategory;
import org.mapsforge.poi.storage.PoiCategoryFilter;

public final class PoiCategoryRangeQueryGenerator {
    private PoiCategoryRangeQueryGenerator() {
    }

    public static String getSQLSelectString(PoiCategoryFilter filter, String pattern) {
        return "SELECT poi_index.id, poi_index.minLat, poi_index.minLon, poi_data.data, poi_data.category FROM poi_index JOIN poi_data ON poi_index.id = poi_data.id WHERE minLat <= ? AND minLon <= ? AND minLat >= ? AND minLon >= ?" + PoiCategoryRangeQueryGenerator.getSQLWhereClauseString(filter) + (pattern != null ? " AND poi_data.data LIKE ?" : "") + " LIMIT ?;";
    }

    private static String getSQLWhereClauseString(PoiCategoryFilter filter) {
        Collection<PoiCategory> superCategories = filter.getAcceptedSuperCategories();
        if (superCategories.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND (");
        Iterator<PoiCategory> superCatIter = superCategories.iterator();
        while (superCatIter.hasNext()) {
            PoiCategory superCat = superCatIter.next();
            Collection<PoiCategory> categories = superCat.deepChildren();
            categories.add(superCat);
            sb.append("poi_data.category IN (");
            Iterator<PoiCategory> catIter = categories.iterator();
            while (catIter.hasNext()) {
                PoiCategory cat = catIter.next();
                sb.append(cat.getID());
                if (!catIter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (!superCatIter.hasNext()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }
}

