/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.poi.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Tag;
import org.mapsforge.poi.storage.PoiCategory;

public class PointOfInterest {
    private final long id;
    private final double latitude;
    private final double longitude;
    private final String data;
    private final PoiCategory category;

    public PointOfInterest(long id, double latitude, double longitude, String data, PoiCategory category) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.data = data;
        this.category = category;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointOfInterest)) {
            return false;
        }
        PointOfInterest other = (PointOfInterest)obj;
        return this.id == other.id;
    }

    public PoiCategory getCategory() {
        return this.category;
    }

    public String getData() {
        return this.data;
    }

    public long getId() {
        return this.id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public LatLong getLatLong() {
        return new LatLong(this.latitude, this.longitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getName() {
        return this.getName(Locale.getDefault().getLanguage());
    }

    public String getName(String language) {
        List<Tag> tags = this.getTags();
        if (language != null && language.trim().length() > 0) {
            String nameStr = "name:" + language.toLowerCase(Locale.ENGLISH);
            for (Tag tag : tags) {
                if (!nameStr.equalsIgnoreCase(tag.key)) continue;
                return tag.value;
            }
            String baseLanguage = language.split("[-_]")[0];
            nameStr = "name:" + baseLanguage.toLowerCase(Locale.ENGLISH);
            for (Tag tag : tags) {
                if (!nameStr.equalsIgnoreCase(tag.key)) continue;
                return tag.value;
            }
        }
        for (Tag tag : tags) {
            if (!"name".equalsIgnoreCase(tag.key)) continue;
            return tag.value;
        }
        if (tags.isEmpty()) {
            return this.data;
        }
        return null;
    }

    public List<Tag> getTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (this.data != null && this.data.trim().length() > 0) {
            String[] split;
            for (String s : split = this.data.split("\r")) {
                if (s.indexOf(61) <= -1) continue;
                tags.add(new Tag(s));
            }
        }
        return tags;
    }

    public String toString() {
        return "POI: (" + this.latitude + ',' + this.longitude + ") " + this.data + ' ' + this.category.getID();
    }
}

