/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.oscim.backend.GL;

public class LwjglGL20
implements GL {
    private ByteBuffer buffer = null;
    private FloatBuffer floatBuffer = null;
    private IntBuffer intBuffer = null;

    private void ensureBufferCapacity(int numBytes) {
        if (this.buffer == null || this.buffer.capacity() < numBytes) {
            this.buffer = BufferUtils.newByteBuffer((int)numBytes);
            this.floatBuffer = this.buffer.asFloatBuffer();
            this.intBuffer = this.buffer.asIntBuffer();
        }
    }

    private FloatBuffer toFloatBuffer(float[] v, int offset, int count) {
        this.ensureBufferCapacity(count << 2);
        this.floatBuffer.clear();
        BufferUtils.copy((float[])v, (Buffer)this.floatBuffer, (int)count, (int)offset);
        return this.floatBuffer;
    }

    private IntBuffer toIntBuffer(int[] v, int offset, int count) {
        this.ensureBufferCapacity(count << 2);
        this.intBuffer.clear();
        BufferUtils.copy((int[])v, (int)count, (int)offset, (Buffer)this.intBuffer);
        return this.intBuffer;
    }

    public void activeTexture(int texture) {
        GL13.glActiveTexture((int)texture);
    }

    public void attachShader(int program, int shader) {
        GL20.glAttachShader((int)program, (int)shader);
    }

    public void bindAttribLocation(int program, int index, String name) {
        GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public void bindBuffer(int target, int buffer) {
        GL15.glBindBuffer((int)target, (int)buffer);
    }

    public void bindFramebuffer(int target, int framebuffer) {
        EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
    }

    public void bindRenderbuffer(int target, int renderbuffer) {
        EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
    }

    public void bindTexture(int target, int texture) {
        GL11.glBindTexture((int)target, (int)texture);
    }

    public void blendColor(float red, float green, float blue, float alpha) {
        GL14.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void blendEquation(int mode) {
        GL14.glBlendEquation((int)mode);
    }

    public void blendEquationSeparate(int modeRGB, int modeAlpha) {
        GL20.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public void blendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL14.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public void bufferData(int target, int size, Buffer data, int usage) {
        if (data == null) {
            GL15.glBufferData((int)target, (long)size, (int)usage);
        } else if (data instanceof ByteBuffer) {
            GL15.glBufferData((int)target, (ByteBuffer)((ByteBuffer)data), (int)usage);
        } else if (data instanceof IntBuffer) {
            GL15.glBufferData((int)target, (IntBuffer)((IntBuffer)data), (int)usage);
        } else if (data instanceof FloatBuffer) {
            GL15.glBufferData((int)target, (FloatBuffer)((FloatBuffer)data), (int)usage);
        } else if (data instanceof DoubleBuffer) {
            GL15.glBufferData((int)target, (DoubleBuffer)((DoubleBuffer)data), (int)usage);
        } else if (data instanceof ShortBuffer) {
            GL15.glBufferData((int)target, (ShortBuffer)((ShortBuffer)data), (int)usage);
        }
    }

    public void bufferSubData(int target, int offset, int size, Buffer data) {
        if (data == null) {
            throw new GdxRuntimeException("Using null for the data not possible, blame LWJGL");
        }
        if (data instanceof ByteBuffer) {
            GL15.glBufferSubData((int)target, (long)offset, (ByteBuffer)((ByteBuffer)data));
        } else if (data instanceof IntBuffer) {
            GL15.glBufferSubData((int)target, (long)offset, (IntBuffer)((IntBuffer)data));
        } else if (data instanceof FloatBuffer) {
            GL15.glBufferSubData((int)target, (long)offset, (FloatBuffer)((FloatBuffer)data));
        } else if (data instanceof DoubleBuffer) {
            GL15.glBufferSubData((int)target, (long)offset, (DoubleBuffer)((DoubleBuffer)data));
        } else if (data instanceof ShortBuffer) {
            GL15.glBufferSubData((int)target, (long)offset, (ShortBuffer)((ShortBuffer)data));
        }
    }

    public int checkFramebufferStatus(int target) {
        return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
    }

    public void clear(int mask) {
        GL11.glClear((int)mask);
    }

    public void clearColor(float red, float green, float blue, float alpha) {
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void clearDepthf(float depth) {
        GL11.glClearDepth((double)depth);
    }

    public void clearStencil(int s) {
        GL11.glClearStencil((int)s);
    }

    public void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public void compileShader(int shader) {
        GL20.glCompileShader((int)shader);
    }

    public void compressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        if (!(data instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Can't use " + data.getClass().getName() + " with this method. Use ByteBuffer instead.");
        }
        GL13.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (ByteBuffer)((ByteBuffer)data));
    }

    public void compressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new GdxRuntimeException("not implemented");
    }

    public void copyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GL11.glCopyTexImage2D((int)target, (int)level, (int)internalformat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public void copyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public int createProgram() {
        return GL20.glCreateProgram();
    }

    public int createShader(int type) {
        return GL20.glCreateShader((int)type);
    }

    public void cullFace(int mode) {
        GL11.glCullFace((int)mode);
    }

    public void deleteBuffers(int n, IntBuffer buffers) {
        GL15.glDeleteBuffers((IntBuffer)buffers);
    }

    public void deleteBuffer(int buffer) {
        GL15.glDeleteBuffers((int)buffer);
    }

    public void deleteFramebuffers(int n, IntBuffer framebuffers) {
        EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)framebuffers);
    }

    public void deleteFramebuffer(int framebuffer) {
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebuffer);
    }

    public void deleteProgram(int program) {
        GL20.glDeleteProgram((int)program);
    }

    public void deleteRenderbuffers(int n, IntBuffer renderbuffers) {
        EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)renderbuffers);
    }

    public void deleteRenderbuffer(int renderbuffer) {
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
    }

    public void deleteShader(int shader) {
        GL20.glDeleteShader((int)shader);
    }

    public void deleteTextures(int n, IntBuffer textures) {
        GL11.glDeleteTextures((IntBuffer)textures);
    }

    public void deleteTexture(int texture) {
        GL11.glDeleteTextures((int)texture);
    }

    public void depthFunc(int func) {
        GL11.glDepthFunc((int)func);
    }

    public void depthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    public void depthRangef(float zNear, float zFar) {
        GL11.glDepthRange((double)zNear, (double)zFar);
    }

    public void detachShader(int program, int shader) {
        GL20.glDetachShader((int)program, (int)shader);
    }

    public void disable(int cap) {
        GL11.glDisable((int)cap);
    }

    public void disableVertexAttribArray(int index) {
        GL20.glDisableVertexAttribArray((int)index);
    }

    public void drawArrays(int mode, int first, int count) {
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void drawElements(int mode, int count, int type, Buffer indices) {
        if (indices instanceof ShortBuffer && type == 5123) {
            GL11.glDrawElements((int)mode, (ShortBuffer)((ShortBuffer)indices));
        } else if (indices instanceof ByteBuffer && type == 5123) {
            GL11.glDrawElements((int)mode, (ShortBuffer)((ByteBuffer)indices).asShortBuffer());
        } else if (indices instanceof ByteBuffer && type == 5121) {
            GL11.glDrawElements((int)mode, (ByteBuffer)((ByteBuffer)indices));
        } else {
            throw new GdxRuntimeException("Can't use " + indices.getClass().getName() + " with this method. Use ShortBuffer or ByteBuffer instead. Blame LWJGL");
        }
    }

    public void enable(int cap) {
        GL11.glEnable((int)cap);
    }

    public void enableVertexAttribArray(int index) {
        GL20.glEnableVertexAttribArray((int)index);
    }

    public void finish() {
        GL11.glFinish();
    }

    public void flush() {
        GL11.glFlush();
    }

    public void framebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public void framebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public void frontFace(int mode) {
        GL11.glFrontFace((int)mode);
    }

    public void genBuffers(int n, IntBuffer buffers) {
        GL15.glGenBuffers((IntBuffer)buffers);
    }

    public int genBuffer() {
        return GL15.glGenBuffers();
    }

    public void genFramebuffers(int n, IntBuffer framebuffers) {
        EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)framebuffers);
    }

    public int genFramebuffer() {
        return EXTFramebufferObject.glGenFramebuffersEXT();
    }

    public void genRenderbuffers(int n, IntBuffer renderbuffers) {
        EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)renderbuffers);
    }

    public int genRenderbuffer() {
        return EXTFramebufferObject.glGenRenderbuffersEXT();
    }

    public void genTextures(int n, IntBuffer textures) {
        GL11.glGenTextures((IntBuffer)textures);
    }

    public int genTexture() {
        return GL11.glGenTextures();
    }

    public void generateMipmap(int target) {
        EXTFramebufferObject.glGenerateMipmapEXT((int)target);
    }

    public String getActiveAttrib(int program, int index, IntBuffer size, Buffer type) {
        IntBuffer typeTmp = org.lwjgl.BufferUtils.createIntBuffer((int)2);
        String name = GL20.glGetActiveAttrib((int)program, (int)index, (int)256, (IntBuffer)typeTmp);
        size.put(typeTmp.get(0));
        if (type instanceof IntBuffer) {
            ((IntBuffer)type).put(typeTmp.get(1));
        }
        return name;
    }

    public String getActiveUniform(int program, int index, IntBuffer size, Buffer type) {
        IntBuffer typeTmp = org.lwjgl.BufferUtils.createIntBuffer((int)2);
        String name = GL20.glGetActiveUniform((int)program, (int)index, (int)256, (IntBuffer)typeTmp);
        size.put(typeTmp.get(0));
        if (type instanceof IntBuffer) {
            ((IntBuffer)type).put(typeTmp.get(1));
        }
        return name;
    }

    public void getAttachedShaders(int program, int maxcount, Buffer count, IntBuffer shaders) {
        GL20.glGetAttachedShaders((int)program, (IntBuffer)((IntBuffer)count), (IntBuffer)shaders);
    }

    public int getAttribLocation(int program, String name) {
        return GL20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    public void getBooleanv(int pname, Buffer params) {
        GL11.glGetBoolean((int)pname, (ByteBuffer)((ByteBuffer)params));
    }

    public void getBufferParameteriv(int target, int pname, IntBuffer params) {
        GL15.glGetBufferParameter((int)target, (int)pname, (IntBuffer)params);
    }

    public int getError() {
        return GL11.glGetError();
    }

    public void getFloatv(int pname, FloatBuffer params) {
        GL11.glGetFloat((int)pname, (FloatBuffer)params);
    }

    public void getFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        EXTFramebufferObject.glGetFramebufferAttachmentParameterEXT((int)target, (int)attachment, (int)pname, (IntBuffer)params);
    }

    public void getIntegerv(int pname, IntBuffer params) {
        GL11.glGetInteger((int)pname, (IntBuffer)params);
    }

    public String getProgramInfoLog(int program) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GL20.glGetProgramInfoLog((int)program, (IntBuffer)intBuffer, (ByteBuffer)buffer);
        int numBytes = intBuffer.get(0);
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return new String(bytes);
    }

    public void getProgramiv(int program, int pname, IntBuffer params) {
        GL20.glGetProgram((int)program, (int)pname, (IntBuffer)params);
    }

    public void getRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        EXTFramebufferObject.glGetRenderbufferParameterEXT((int)target, (int)pname, (IntBuffer)params);
    }

    public String getShaderInfoLog(int shader) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GL20.glGetShaderInfoLog((int)shader, (IntBuffer)intBuffer, (ByteBuffer)buffer);
        int numBytes = intBuffer.get(0);
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return new String(bytes);
    }

    public void getShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void getShaderiv(int shader, int pname, IntBuffer params) {
        GL20.glGetShader((int)shader, (int)pname, (IntBuffer)params);
    }

    public String getString(int name) {
        return GL11.glGetString((int)name);
    }

    public void getTexParameterfv(int target, int pname, FloatBuffer params) {
        GL11.glGetTexParameter((int)target, (int)pname, (FloatBuffer)params);
    }

    public void getTexParameteriv(int target, int pname, IntBuffer params) {
        GL11.glGetTexParameter((int)target, (int)pname, (IntBuffer)params);
    }

    public int getUniformLocation(int program, String name) {
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public void getUniformfv(int program, int location, FloatBuffer params) {
        GL20.glGetUniform((int)program, (int)location, (FloatBuffer)params);
    }

    public void getUniformiv(int program, int location, IntBuffer params) {
        GL20.glGetUniform((int)program, (int)location, (IntBuffer)params);
    }

    public void getVertexAttribPointerv(int index, int pname, Buffer pointer) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void getVertexAttribfv(int index, int pname, FloatBuffer params) {
        GL20.glGetVertexAttrib((int)index, (int)pname, (FloatBuffer)params);
    }

    public void getVertexAttribiv(int index, int pname, IntBuffer params) {
        GL20.glGetVertexAttrib((int)index, (int)pname, (IntBuffer)params);
    }

    public void hint(int target, int mode) {
        GL11.glHint((int)target, (int)mode);
    }

    public boolean isBuffer(int buffer) {
        return GL15.glIsBuffer((int)buffer);
    }

    public boolean isEnabled(int cap) {
        return GL11.glIsEnabled((int)cap);
    }

    public boolean isFramebuffer(int framebuffer) {
        return EXTFramebufferObject.glIsFramebufferEXT((int)framebuffer);
    }

    public boolean isProgram(int program) {
        return GL20.glIsProgram((int)program);
    }

    public boolean isRenderbuffer(int renderbuffer) {
        return EXTFramebufferObject.glIsRenderbufferEXT((int)renderbuffer);
    }

    public boolean isShader(int shader) {
        return GL20.glIsShader((int)shader);
    }

    public boolean isTexture(int texture) {
        return GL11.glIsTexture((int)texture);
    }

    public void lineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public void linkProgram(int program) {
        GL20.glLinkProgram((int)program);
    }

    public void pixelStorei(int pname, int param) {
        GL11.glPixelStorei((int)pname, (int)param);
    }

    public void polygonOffset(float factor, float units) {
        GL11.glPolygonOffset((float)factor, (float)units);
    }

    public void readPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer or FloatBuffer instead. Blame LWJGL");
        }
    }

    public void releaseShaderCompiler() {
    }

    public void renderbufferStorage(int target, int internalformat, int width, int height) {
        EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalformat, (int)width, (int)height);
    }

    public void sampleCoverage(float value, boolean invert) {
        GL13.glSampleCoverage((float)value, (boolean)invert);
    }

    public void scissor(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void shaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void shaderSource(int shader, String string) {
        GL20.glShaderSource((int)shader, (CharSequence)string);
    }

    public void stencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public void stencilFuncSeparate(int face, int func, int ref, int mask) {
        GL20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void stencilMask(int mask) {
        GL11.glStencilMask((int)mask);
    }

    public void stencilMaskSeparate(int face, int mask) {
        GL20.glStencilMaskSeparate((int)face, (int)mask);
    }

    public void stencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public void stencilOpSeparate(int face, int fail, int zfail, int zpass) {
        GL20.glStencilOpSeparate((int)face, (int)fail, (int)zfail, (int)zpass);
    }

    public void texImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        if (pixels == null) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)null);
        } else if (pixels instanceof ByteBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else if (pixels instanceof DoubleBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (DoubleBuffer)((DoubleBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    public void texParameterf(int target, int pname, float param) {
        GL11.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void texParameterfv(int target, int pname, FloatBuffer params) {
        GL11.glTexParameter((int)target, (int)pname, (FloatBuffer)params);
    }

    public void texParameteri(int target, int pname, int param) {
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void texParameteriv(int target, int pname, IntBuffer params) {
        GL11.glTexParameter((int)target, (int)pname, (IntBuffer)params);
    }

    public void texSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else if (pixels instanceof DoubleBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (DoubleBuffer)((DoubleBuffer)pixels));
        } else {
            throw new GdxRuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    public void uniform1f(int location, float x) {
        GL20.glUniform1f((int)location, (float)x);
    }

    public void uniform1fv(int location, int count, FloatBuffer v) {
        GL20.glUniform1((int)location, (FloatBuffer)v);
    }

    public void uniform1fv(int location, int count, float[] v, int offset) {
        GL20.glUniform1((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count));
    }

    public void uniform1i(int location, int x) {
        GL20.glUniform1i((int)location, (int)x);
    }

    public void uniform1iv(int location, int count, IntBuffer v) {
        GL20.glUniform1((int)location, (IntBuffer)v);
    }

    public void uniform1iv(int location, int count, int[] v, int offset) {
        GL20.glUniform1((int)location, (IntBuffer)this.toIntBuffer(v, offset, count));
    }

    public void uniform2f(int location, float x, float y) {
        GL20.glUniform2f((int)location, (float)x, (float)y);
    }

    public void uniform2fv(int location, int count, FloatBuffer v) {
        GL20.glUniform2((int)location, (FloatBuffer)v);
    }

    public void uniform2fv(int location, int count, float[] v, int offset) {
        GL20.glUniform2((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count << 1));
    }

    public void uniform2i(int location, int x, int y) {
        GL20.glUniform2i((int)location, (int)x, (int)y);
    }

    public void uniform2iv(int location, int count, IntBuffer v) {
        GL20.glUniform2((int)location, (IntBuffer)v);
    }

    public void uniform2iv(int location, int count, int[] v, int offset) {
        GL20.glUniform2((int)location, (IntBuffer)this.toIntBuffer(v, offset, count << 1));
    }

    public void uniform3f(int location, float x, float y, float z) {
        GL20.glUniform3f((int)location, (float)x, (float)y, (float)z);
    }

    public void uniform3fv(int location, int count, FloatBuffer v) {
        GL20.glUniform3((int)location, (FloatBuffer)v);
    }

    public void uniform3fv(int location, int count, float[] v, int offset) {
        GL20.glUniform3((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count * 3));
    }

    public void uniform3i(int location, int x, int y, int z) {
        GL20.glUniform3i((int)location, (int)x, (int)y, (int)z);
    }

    public void uniform3iv(int location, int count, IntBuffer v) {
        GL20.glUniform3((int)location, (IntBuffer)v);
    }

    public void uniform3iv(int location, int count, int[] v, int offset) {
        GL20.glUniform3((int)location, (IntBuffer)this.toIntBuffer(v, offset, count * 3));
    }

    public void uniform4f(int location, float x, float y, float z, float w) {
        GL20.glUniform4f((int)location, (float)x, (float)y, (float)z, (float)w);
    }

    public void uniform4fv(int location, int count, FloatBuffer v) {
        GL20.glUniform4((int)location, (FloatBuffer)v);
    }

    public void uniform4fv(int location, int count, float[] v, int offset) {
        GL20.glUniform4((int)location, (FloatBuffer)this.toFloatBuffer(v, offset, count << 2));
    }

    public void uniform4i(int location, int x, int y, int z, int w) {
        GL20.glUniform4i((int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public void uniform4iv(int location, int count, IntBuffer v) {
        GL20.glUniform4((int)location, (IntBuffer)v);
    }

    public void uniform4iv(int location, int count, int[] v, int offset) {
        GL20.glUniform4((int)location, (IntBuffer)this.toIntBuffer(v, offset, count << 2));
    }

    public void uniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix2((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void uniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        GL20.glUniformMatrix2((int)location, (boolean)transpose, (FloatBuffer)this.toFloatBuffer(value, offset, count << 2));
    }

    public void uniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix3((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void uniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        GL20.glUniformMatrix3((int)location, (boolean)transpose, (FloatBuffer)this.toFloatBuffer(value, offset, count * 9));
    }

    public void uniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL20.glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)value);
    }

    public void uniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        GL20.glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)this.toFloatBuffer(value, offset, count << 4));
    }

    public void useProgram(int program) {
        GL20.glUseProgram((int)program);
    }

    public void validateProgram(int program) {
        GL20.glValidateProgram((int)program);
    }

    public void vertexAttrib1f(int indx, float x) {
        GL20.glVertexAttrib1f((int)indx, (float)x);
    }

    public void vertexAttrib1fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib1f((int)indx, (float)values.get());
    }

    public void vertexAttrib2f(int indx, float x, float y) {
        GL20.glVertexAttrib2f((int)indx, (float)x, (float)y);
    }

    public void vertexAttrib2fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib2f((int)indx, (float)values.get(), (float)values.get());
    }

    public void vertexAttrib3f(int indx, float x, float y, float z) {
        GL20.glVertexAttrib3f((int)indx, (float)x, (float)y, (float)z);
    }

    public void vertexAttrib3fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib3f((int)indx, (float)values.get(), (float)values.get(), (float)values.get());
    }

    public void vertexAttrib4f(int indx, float x, float y, float z, float w) {
        GL20.glVertexAttrib4f((int)indx, (float)x, (float)y, (float)z, (float)w);
    }

    public void vertexAttrib4fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib4f((int)indx, (float)values.get(), (float)values.get(), (float)values.get(), (float)values.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void vertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            if (type == 5120) {
                GL20.glVertexAttribPointer((int)indx, (int)size, (boolean)false, (boolean)normalized, (int)stride, (ByteBuffer)((ByteBuffer)buffer));
                return;
            } else if (type == 5121) {
                GL20.glVertexAttribPointer((int)indx, (int)size, (boolean)true, (boolean)normalized, (int)stride, (ByteBuffer)((ByteBuffer)buffer));
                return;
            } else if (type == 5122) {
                GL20.glVertexAttribPointer((int)indx, (int)size, (boolean)false, (boolean)normalized, (int)stride, (ShortBuffer)((ByteBuffer)buffer).asShortBuffer());
                return;
            } else if (type == 5123) {
                GL20.glVertexAttribPointer((int)indx, (int)size, (boolean)true, (boolean)normalized, (int)stride, (ShortBuffer)((ByteBuffer)buffer).asShortBuffer());
                return;
            } else {
                if (type != 5126) throw new GdxRuntimeException("Can't use " + buffer.getClass().getName() + " with type " + type + " with this method. Use ByteBuffer and one of GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT or GL_FLOAT for type. Blame LWJGL");
                GL20.glVertexAttribPointer((int)indx, (int)size, (boolean)normalized, (int)stride, (FloatBuffer)((ByteBuffer)buffer).asFloatBuffer());
            }
            return;
        } else {
            if (!(buffer instanceof FloatBuffer)) throw new GdxRuntimeException("Can't use " + buffer.getClass().getName() + " with this method. Use ByteBuffer instead. Blame LWJGL");
            if (type != 5126) throw new GdxRuntimeException("Can't use " + buffer.getClass().getName() + " with type " + type + " with this method.");
            GL20.glVertexAttribPointer((int)indx, (int)size, (boolean)normalized, (int)stride, (FloatBuffer)((FloatBuffer)buffer));
        }
    }

    public void viewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void drawElements(int mode, int count, int type, int indices) {
        GL11.glDrawElements((int)mode, (int)count, (int)type, (long)indices);
    }

    public void vertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        GL20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (long)ptr);
    }
}

